/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.metadata.MetadataCache;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataProvider;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.util.TemplateParser;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.values.ComponentValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.extension.internal.property.PagedOperationModelProperty;
import org.mule.runtime.module.extension.internal.ExtensionResolvingContext;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.module.extension.internal.metadata.MetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.extension.internal.value.ValueProviderMediator;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExtensionComponent<T extends ComponentModel>
extends AbstractComponent
implements MuleContextAware,
MetadataKeyProvider,
MetadataProvider<T>,
ComponentValueProvider,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionComponent.class);
    private final TemplateParser expressionParser = TemplateParser.createMuleStyleParser();
    private final ExtensionModel extensionModel;
    private final AtomicReference<ConfigurationProvider> configurationProvider = new AtomicReference();
    private final MetadataMediator<T> metadataMediator;
    private final ValueProviderMediator<T> valueProviderMediator;
    private final ClassTypeLoader typeLoader;
    private final LazyValue<Boolean> requiresConfig = new LazyValue<Supplier<Boolean>>(this::computeRequiresConfig);
    protected final ExtensionManager extensionManager;
    protected final ClassLoader classLoader;
    protected final T componentModel;
    protected CursorProviderFactory cursorProviderFactory;
    protected MuleContext muleContext;
    @Inject
    protected ConnectionManagerAdapter connectionManager;
    @Inject
    protected StreamingManager streamingManager;
    @Inject
    protected TransactionFactoryLocator transactionFactoryLocator;
    @Inject
    protected MuleMetadataService metadataService;
    @Inject
    private ConfigurationComponentLocator componentLocator;
    @Inject
    protected ReflectionCache reflectionCache;
    @Inject
    private MetadataCacheIdGeneratorFactory<ComponentConfiguration> cacheIdGeneratorFactory;
    protected MetadataCacheIdGenerator<ComponentConfiguration> cacheIdGenerator;

    protected ExtensionComponent(ExtensionModel extensionModel, T componentModel, ConfigurationProvider configurationProvider, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager) {
        this.extensionModel = extensionModel;
        this.classLoader = MuleExtensionUtils.getClassLoader(extensionModel);
        this.componentModel = componentModel;
        this.configurationProvider.set(configurationProvider);
        this.extensionManager = extensionManager;
        this.cursorProviderFactory = cursorProviderFactory;
        this.metadataMediator = new MetadataMediator<T>(componentModel);
        this.valueProviderMediator = new ValueProviderMediator<T>(componentModel, () -> this.muleContext, () -> this.reflectionCache);
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(this.classLoader);
    }

    @Override
    public final void initialise() throws InitialisationException {
        if (this.cursorProviderFactory == null) {
            this.cursorProviderFactory = this.componentModel.getModelProperty(PagedOperationModelProperty.class).map(p -> this.streamingManager.forObjects().getDefaultCursorProviderFactory()).orElseGet(() -> this.streamingManager.forBytes().getDefaultCursorProviderFactory());
        }
        ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.validateConfigurationProviderIsNotExpression();
            this.findConfigurationProvider().ifPresent(this::validateOperationConfiguration);
            this.doInitialise();
            return null;
        }, InitialisationException.class, e -> {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        });
        this.setCacheIdGenerator();
    }

    @Override
    public final void start() throws MuleException {
        ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.doStart();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException(e);
        });
    }

    @Override
    public final void stop() throws MuleException {
        ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.doStop();
            return null;
        }, MuleException.class, e -> {
            throw new DefaultMuleException(e);
        });
    }

    @Override
    public final void dispose() {
        try {
            ClassUtils.withContextClassLoader(this.classLoader, () -> {
                this.doDispose();
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.warn("Exception found trying to dispose component", (Throwable)e);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doStart() throws MuleException;

    protected abstract void doStop() throws MuleException;

    protected abstract void doDispose();

    protected abstract void validateOperationConfiguration(ConfigurationProvider var1);

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.metadataMediator.getMetadataKeys((MetadataContext)context, this.getParameterValueResolver(), this.reflectionCache)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.metadataMediator.getMetadata((MetadataContext)context, this.getParameterValueResolver(), this.reflectionCache)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.metadataMediator.getMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onComponent());
        }
    }

    @Override
    public Set<Value> getValues(String parameterName) throws ValueResolvingException {
        try {
            return this.runWithValueProvidersContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.valueProviderMediator.getValues(parameterName, this.getParameterValueResolver(), () -> context.getConnection().orElse(null), () -> context.getConfig().orElse(null))));
        }
        catch (MuleRuntimeException e) {
            Throwable rootException = ExceptionHelper.getRootException(e);
            if (rootException instanceof ValueResolvingException) {
                throw (ValueResolvingException)rootException;
            }
            throw new ValueResolvingException("An unknown error occurred trying to resolve values. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
        catch (Exception e) {
            throw new ValueResolvingException("An unknown error occurred trying to resolve values. " + e.getCause().getMessage(), "UNKNOWN", (Throwable)e);
        }
    }

    protected <R> MetadataResult<R> runWithMetadataContext(Function<MetadataContext, MetadataResult<R>> contextConsumer) throws MetadataResolvingException, ConnectionException {
        Disposable context = null;
        try {
            MetadataCacheId cacheId = this.getMetadataCacheId();
            MetadataCache metadataCache = this.metadataService.getMetadataCache(cacheId.getValue());
            context = ClassUtils.withContextClassLoader(this.classLoader, () -> this.getMetadataContext(metadataCache));
            MetadataResult<R> result = contextConsumer.apply((MetadataContext)context);
            if (result.isSuccess()) {
                this.metadataService.saveCache(cacheId.getValue(), metadataCache);
            }
            MetadataResult<R> metadataResult = result;
            return metadataResult;
        }
        catch (MuleRuntimeException e) {
            try {
                throw e.getCause();
            }
            catch (ConnectionException | MetadataResolvingException cause) {
                throw cause;
            }
            catch (Throwable t) {
                throw e;
            }
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
    }

    private MetadataCacheId getMetadataCacheId() {
        return this.cacheIdGenerator.getIdForGlobalMetadata((ComponentConfiguration)this.getAnnotation(ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG)).map(id -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(id.getParts().toString());
            }
            return id;
        }).orElseThrow(() -> new IllegalStateException(String.format("Missing information to obtain the MetadataCache for the component '%s'. Expected to have the ComponentConfiguration information in the '%s' annotation but none was found.", this.getLocation().toString(), ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R runWithValueProvidersContext(Function<ExtensionResolvingContext, R> valueProviderFunction) {
        R result;
        ExtensionResolvingContext context = this.getResolvingContext();
        try {
            result = valueProviderFunction.apply(context);
        }
        finally {
            context.dispose();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataContext getMetadataContext(MetadataCache cache) throws MetadataResolvingException {
        CoreEvent fakeEvent = null;
        try {
            ConfigurationProvider configurationProvider;
            fakeEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
            Optional<ConfigurationInstance> configuration = this.getConfiguration(fakeEvent);
            if (configuration.isPresent() && (configurationProvider = this.findConfigurationProvider().orElseThrow(() -> new MetadataResolvingException("Failed to create the required configuration for Metadata retrieval", FailureCode.INVALID_CONFIGURATION))) instanceof DynamicConfigurationProvider) {
                throw new MetadataResolvingException("Configuration used for Metadata fetch cannot be dynamic", FailureCode.INVALID_CONFIGURATION);
            }
            DefaultMetadataContext defaultMetadataContext = new DefaultMetadataContext(() -> configuration, this.connectionManager, cache, this.typeLoader);
            return defaultMetadataContext;
        }
        finally {
            if (fakeEvent != null) {
                ((BaseEventContext)fakeEvent.getContext()).success();
            }
        }
    }

    private ExtensionResolvingContext getResolvingContext() {
        return new ExtensionResolvingContext(() -> {
            CoreEvent fakeEvent = null;
            try {
                fakeEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
                Optional<ConfigurationInstance> optional = this.getConfiguration(fakeEvent);
                return optional;
            }
            finally {
                if (fakeEvent != null) {
                    ((BaseEventContext)fakeEvent.getContext()).success();
                }
            }
        }, this.connectionManager);
    }

    protected Optional<ConfigurationInstance> getConfiguration(CoreEvent event) {
        if (!this.requiresConfig.get().booleanValue()) {
            return Optional.empty();
        }
        if (this.isConfigurationSpecified()) {
            return Optional.of(this.configurationProvider.get()).map(provider -> Optional.ofNullable(provider.get(event))).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Root component '%s' contains a reference to config '%s' but it doesn't exists", this.getLocation().getRootContainerName(), this.configurationProvider)));
        }
        return this.getDefaultConfiguraiton(event);
    }

    private Optional<ConfigurationInstance> getDefaultConfiguraiton(CoreEvent event) {
        return this.extensionManager.getConfigurationProvider(this.extensionModel, (ComponentModel)this.componentModel).map(provider -> {
            this.configurationProvider.set((ConfigurationProvider)provider);
            return Optional.ofNullable(provider.get(event));
        }).orElseGet(() -> this.extensionManager.getConfiguration(this.extensionModel, (ComponentModel)this.componentModel, event));
    }

    protected Optional<ConfigurationInstance> getStaticConfiguration() {
        if (!this.requiresConfig.get().booleanValue() || this.isConfigurationSpecified() && this.configurationProvider.get().isDynamic()) {
            return Optional.empty();
        }
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = org.mule.runtime.module.extension.api.util.MuleExtensionUtils.getInitialiserEvent(this.muleContext);
            Optional<ConfigurationInstance> optional = this.getConfiguration(initialiserEvent);
            return optional;
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
    }

    protected CursorProviderFactory getCursorProviderFactory() {
        return this.cursorProviderFactory;
    }

    private Optional<ConfigurationProvider> findConfigurationProvider() {
        if (this.isConfigurationSpecified()) {
            return Optional.of(this.configurationProvider.get());
        }
        return this.extensionManager.getConfigurationProvider(this.extensionModel, (ComponentModel)this.componentModel);
    }

    private boolean isConfigurationSpecified() {
        return this.configurationProvider.get() != null;
    }

    private boolean computeRequiresConfig() {
        return ExtensionModelUtils.requiresConfig(this.extensionModel, this.componentModel);
    }

    private void validateConfigurationProviderIsNotExpression() throws InitialisationException {
        if (this.isConfigurationSpecified() && this.expressionParser.isContainsTemplate(this.configurationProvider.get().getName())) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage(String.format("Root component '%s' defines component '%s' which specifies the expression '%s' as a config-ref. Expressions are not allowed as config references", this.getLocation().getRootContainerName(), NameUtils.hyphenize(this.componentModel.getName()), this.configurationProvider)), (Initialisable)this);
        }
    }

    private void setCacheIdGenerator() {
        DslResolvingContext context = DslResolvingContext.getDefault(this.extensionManager.getExtensions());
        MetadataCacheIdGeneratorFactory.ComponentLocator configLocator = location -> this.componentLocator.find(location).map(component -> (ComponentConfiguration)component.getAnnotation(ComponentAnnotations.ANNOTATION_COMPONENT_CONFIG));
        this.cacheIdGenerator = this.cacheIdGeneratorFactory.create(context, configLocator);
    }

    protected abstract ParameterValueResolver getParameterValueResolver();

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }

    @Override
    public List<ValueProviderModel> getModels(String providerName) {
        return ValueProviderUtils.getValueProviderModels(this.componentModel.getAllParameterModels());
    }
}

