/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionBasedValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.RequiredParameterValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class ExclusiveParameterGroupObjectBuilder<T>
extends DefaultObjectBuilder<T> {
    private final ExclusiveOptionalsTypeAnnotation exclusiveOptionalsTypeAnnotation;
    private final boolean lazyInitEnabled;

    public ExclusiveParameterGroupObjectBuilder(Class<T> prototypeClass, ExclusiveOptionalsTypeAnnotation exclusiveOptionalsTypeAnnotation, boolean lazyInitEnabled, ReflectionCache reflectionCache) {
        super(prototypeClass, reflectionCache);
        this.exclusiveOptionalsTypeAnnotation = exclusiveOptionalsTypeAnnotation;
        this.lazyInitEnabled = lazyInitEnabled;
    }

    @Override
    public ObjectBuilder<T> addPropertyResolver(String propertyName, ValueResolver<? extends Object> resolver) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)propertyName), "property name cannot be blank");
        Preconditions.checkArgument(resolver != null, "resolver cannot be null");
        return super.addPropertyResolver(propertyName, this.wrapResolver(propertyName, resolver));
    }

    @Override
    public ObjectBuilder<T> addPropertyResolver(Field field, ValueResolver<? extends Object> resolver) {
        Preconditions.checkArgument(resolver != null, "resolver cannot be null");
        return super.addPropertyResolver(field, this.wrapResolver(field.getName(), resolver));
    }

    private ValueResolver<? extends Object> wrapResolver(String propertyName, ValueResolver<? extends Object> resolver) {
        if (this.exclusiveOptionalsTypeAnnotation.isOneRequired() && resolver.isDynamic() && this.exclusiveOptionalsTypeAnnotation.getExclusiveParameterNames().contains(propertyName)) {
            resolver = resolver instanceof ExpressionBasedValueResolver ? new RequiredParameterValueResolverWrapper<Object>(resolver, propertyName, ((ExpressionBasedValueResolver)resolver).getExpression()) : new RequiredParameterValueResolverWrapper<Object>(resolver, propertyName);
        }
        return resolver;
    }

    @Override
    public T build(ValueResolvingContext context) throws MuleException {
        if (!this.lazyInitEnabled) {
            Collection definedExclusiveParameters = CollectionUtils.intersection(this.exclusiveOptionalsTypeAnnotation.getExclusiveParameterNames(), (Collection)this.resolvers.keySet().stream().map(TypeUtils::getAlias).collect(Collectors.toSet()));
            if (definedExclusiveParameters.isEmpty() && this.exclusiveOptionalsTypeAnnotation.isOneRequired()) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Parameter group of type '%s' requires that one of its optional parameters should be set but all of them are missing. One of the following should be set: [%s]", this.prototypeClass.getName(), Joiner.on((String)", ").join(this.exclusiveOptionalsTypeAnnotation.getExclusiveParameterNames()))));
            }
            if (definedExclusiveParameters.size() > 1) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage(String.format("In Parameter group of type '%s', the following parameters cannot be set at the same time: [%s]", this.prototypeClass.getName(), Joiner.on((String)", ").join((Iterable)definedExclusiveParameters))));
            }
        }
        return super.build(context);
    }
}

