/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.param.display.ClassValue;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class DisplayDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.LAYOUT;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichTypes(declaration);
            }

            @Override
            protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichParameter(declaration);
            }

            @Override
            public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichOperation(declaration);
            }

            @Override
            public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichTypes(declaration);
            }

            @Override
            public void onConfiguration(ConfigurationDeclaration declaration) {
                DisplayDeclarationEnricher.this.enrichTypes(declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private void enrichParameter(ParameterDeclaration declaration) {
        declaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class).ifPresent(modelProperty -> this.enrichDeclaration(declaration, modelProperty.getExtensionParameter()));
    }

    private void enrichTypes(BaseDeclaration declaration) {
        Optional<ImplementingTypeModelProperty> modelProperty = declaration.getModelProperty(ImplementingTypeModelProperty.class);
        if (modelProperty.isPresent()) {
            Class<?> annotatedType = modelProperty.get().getType();
            Summary summaryAnnotation = IntrospectionUtils.getAnnotation(annotatedType, Summary.class);
            DisplayName displayNameAnnotation = IntrospectionUtils.getAnnotation(annotatedType, DisplayName.class);
            Example exampleAnnotation = IntrospectionUtils.getAnnotation(annotatedType, Example.class);
            Path pathAnnotation = IntrospectionUtils.getAnnotation(annotatedType, Path.class);
            ClassValue classAnnotation = IntrospectionUtils.getAnnotation(annotatedType, ClassValue.class);
            this.createDisplayModelProperty(declaration, summaryAnnotation, displayNameAnnotation, exampleAnnotation, pathAnnotation, classAnnotation);
        }
    }

    private void enrichOperation(OperationDeclaration declaration) {
        declaration.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(ExtensionOperationDescriptorModelProperty::getOperationMethod).ifPresent(annotatedElement -> this.enrichDeclaration(declaration, (WithAnnotations)annotatedElement));
    }

    private void enrichDeclaration(BaseDeclaration declaration, WithAnnotations annotatedElement) {
        if (annotatedElement != null) {
            Summary summaryAnnotation = annotatedElement.getAnnotation(Summary.class).orElse(null);
            DisplayName displayNameAnnotation = annotatedElement.getAnnotation(DisplayName.class).orElse(null);
            Example exampleAnnotation = annotatedElement.getAnnotation(Example.class).orElse(null);
            Path pathAnnotation = annotatedElement.getAnnotation(Path.class).orElse(null);
            ClassValue classValue = annotatedElement.getAnnotation(ClassValue.class).orElse(null);
            this.createDisplayModelProperty(declaration, summaryAnnotation, displayNameAnnotation, exampleAnnotation, pathAnnotation, classValue);
        }
    }

    private void createDisplayModelProperty(BaseDeclaration declaration, Summary summaryAnnotation, DisplayName displayNameAnnotation, Example exampleAnnotation, Path pathAnnotation, ClassValue classValue) {
        String summary = summaryAnnotation != null ? summaryAnnotation.value() : null;
        String displayName = displayNameAnnotation != null ? displayNameAnnotation.value() : null;
        String example = exampleAnnotation != null ? exampleAnnotation.value() : null;
        PathModel pathModel = null;
        ClassValueModel classValueModel = null;
        if (pathAnnotation != null) {
            pathModel = new PathModel(pathAnnotation.type(), pathAnnotation.acceptsUrls(), pathAnnotation.location(), pathAnnotation.acceptedFileExtensions());
        }
        if (classValue != null) {
            classValueModel = ExtensionModelUtils.toClassValueModel(classValue);
        }
        if (summary != null || displayName != null || example != null || pathModel != null || classValueModel != null) {
            declaration.setDisplayModel(DisplayModel.builder().displayName(displayName).summary(summary).example(example).path(pathModel).classValue(classValueModel).build());
        }
    }
}

