/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.module.reader.CharsetHelper$;
import org.mule.weave.v2.module.reader.SourceReader;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001=\u0011a#\u0016+GqM#(/Z1n'>,(oY3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\taA]3bI\u0016\u0014(BA\u0003\u0007\u0003\u0019iw\u000eZ;mK*\u0011q\u0001C\u0001\u0003mJR!!\u0003\u0006\u0002\u000b],\u0017M^3\u000b\u0005-a\u0011\u0001B7vY\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eQR\"\u0001\u0002\n\u0005m\u0011!\u0001D*pkJ\u001cWMU3bI\u0016\u0014\b\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001dM,Wm[1cY\u0016\u001cFO]3b[B\u0011qDI\u0007\u0002A)\u0011\u0011EB\u0001\u0003S>L!a\t\u0011\u0003\u001dM+Wm[1cY\u0016\u001cFO]3b[\"AQ\u0005\u0001B\u0001B\u0003%a%A\u0004dQ\u0006\u00148/\u001a;\u0011\u0005\u001dZS\"\u0001\u0015\u000b\u0005\u0015J#B\u0001\u0016\u0015\u0003\rq\u0017n\\\u0005\u0003Y!\u0012qa\u00115beN,G\u000fC\u0003/\u0001\u0011\u0005q&\u0001\u0004=S:LGO\u0010\u000b\u0004aE\u0012\u0004CA\r\u0001\u0011\u0015iR\u00061\u0001\u001f\u0011\u0015)S\u00061\u0001'\u0011!!\u0004\u0001#b\u0001\n\u0003)\u0014a\u00023fG>$WM]\u000b\u0002mA\u0011qeN\u0005\u0003q!\u0012ab\u00115beN,G\u000fR3d_\u0012,'\u000fC\u0004;\u0001\t\u0007I\u0011B\u001e\u0002\u0015\rD\u0017M\u001d\"vM\u001a,'/F\u0001=!\tid(D\u0001*\u0013\ty\u0014F\u0001\u0006DQ\u0006\u0014()\u001e4gKJDa!\u0011\u0001!\u0002\u0013a\u0014aC2iCJ\u0014UO\u001a4fe\u0002Bqa\u0011\u0001A\u0002\u0013%1(A\u0007cS\u001e\u001c\u0005.\u0019:Ck\u001a4WM\u001d\u0005\b\u000b\u0002\u0001\r\u0011\"\u0003G\u0003E\u0011\u0017nZ\"iCJ\u0014UO\u001a4fe~#S-\u001d\u000b\u0003\u000f6\u0003\"\u0001S&\u000e\u0003%S\u0011AS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0019&\u0013A!\u00168ji\"9a\nRA\u0001\u0002\u0004a\u0014a\u0001=%c!1\u0001\u000b\u0001Q!\nq\naBY5h\u0007\"\f'OQ;gM\u0016\u0014\b\u0005C\u0004S\u0001\u0001\u0007I\u0011A*\u0002\u0015}\u0013X-\u00193CsR,7/F\u0001U!\tAU+\u0003\u0002W\u0013\n\u0019\u0011J\u001c;\t\u000fa\u0003\u0001\u0019!C\u00013\u0006qqL]3bI\nKH/Z:`I\u0015\fHCA$[\u0011\u001dqu+!AA\u0002QCa\u0001\u0018\u0001!B\u0013!\u0016aC0sK\u0006$')\u001f;fg\u0002BQA\u0018\u0001\u0005B}\u000b\u0011B]3bI\u0006\u001b8-[5\u0015\u0003\u0001\u0004\"\u0001S1\n\u0005\tL%\u0001B\"iCJDQ\u0001\u001a\u0001\u0005\u0002\u0015\f\u0011\u0002[1oI2,'iT'\u0015\u0003\u001dCQa\u001a\u0001\u0005B!\f\u0001\u0002]8tSRLwN\u001c\u000b\u0002SB\u0011\u0001J[\u0005\u0003W&\u0013A\u0001T8oO\")Q\u000e\u0001C!Q\u0006\u0001\u0002O]3wS>,8\u000fU8tSRLwN\u001c\u0005\u0006_\u0002!\teX\u0001\u000fY>|7.\u00115fC\u0012\f5oY5j\u0011\u0015\t\b\u0001\"\u0011s\u0003\u0011\u0019X-Z6\u0015\u0005\u001d\u001b\b\"B4q\u0001\u0004I\u0007\"B;\u0001\t\u00032\u0018AD5o\u001b\u0016lwN]=SK\u0006$WM\u001d\u000b\u0002oB\u0011\u0001\n_\u0005\u0003s&\u0013qAQ8pY\u0016\fg\u000eC\u0003|\u0001\u0011\u0005s,\u0001\u0003sK\u0006$\u0007\"B?\u0001\t\u0003q\u0018!\u0005:fC\u0012,enY8eK\u0012\u001cFO]5oOR)q0!\u0006\u0002\u001aA!\u0011\u0011AA\b\u001d\u0011\t\u0019!a\u0003\u0011\u0007\u0005\u0015\u0011*\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\b\u0002\rq\u0012xn\u001c;?\u0013\r\ti!S\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00111\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\u0011\n\u0003\u0004\u0002\u0018q\u0004\r![\u0001\u0005MJ|W\u000e\u0003\u0004\u0002\u001cq\u0004\r![\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005y!/Z1e\u0003N\u001c\u0017.[*ue&tw\rF\u0003\u0000\u0003G\t)\u0003C\u0004\u0002\u0018\u0005u\u0001\u0019A5\t\u000f\u0005m\u0011Q\u0004a\u0001S\"1\u0011\u0011\u0006\u0001\u0005B\u0015\fQa\u00197pg\u0016\u0004")
public class UTF8StreamSourceReader
implements SourceReader {
    private CharsetDecoder decoder;
    private final SeekableStream seekableStream;
    private final Charset charset;
    private final CharBuffer charBuffer;
    private CharBuffer bigCharBuffer;
    private int _readBytes;
    private volatile boolean bitmap$0;

    private CharsetDecoder decoder$lzycompute() {
        UTF8StreamSourceReader uTF8StreamSourceReader = this;
        synchronized (uTF8StreamSourceReader) {
            if (!this.bitmap$0) {
                this.decoder = this.charset.newDecoder();
                this.bitmap$0 = true;
            }
        }
        return this.decoder;
    }

    public CharsetDecoder decoder() {
        return !this.bitmap$0 ? this.decoder$lzycompute() : this.decoder;
    }

    private CharBuffer charBuffer() {
        return this.charBuffer;
    }

    private CharBuffer bigCharBuffer() {
        return this.bigCharBuffer;
    }

    private void bigCharBuffer_$eq(CharBuffer x$1) {
        this.bigCharBuffer = x$1;
    }

    public int _readBytes() {
        return this._readBytes;
    }

    public void _readBytes_$eq(int x$1) {
        this._readBytes = x$1;
    }

    @Override
    public char readAscii() {
        char c;
        int read;
        if (this.seekableStream.position() == 0L) {
            this.handleBOM();
        }
        if ((read = ((InputStream)((Object)this.seekableStream)).read()) != -1) {
            this._readBytes_$eq(1);
            c = (char)(read & 0xFF);
        } else {
            this._readBytes_$eq(0);
            c = '\uffff';
        }
        return c;
    }

    public void handleBOM() {
        block0: {
            Option<byte[]> mayBeBom = CharsetHelper$.MODULE$.getBom(this.charset);
            byte[] bom = (byte[])mayBeBom.get();
            byte[] inputBom = new byte[bom.length];
            ((InputStream)((Object)this.seekableStream)).read(inputBom);
            if (inputBom[0] == bom[0] && inputBom[1] == bom[1] && inputBom[2] == bom[2]) break block0;
            this.seekableStream.seek(0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long position() {
        long l;
        long position = this.seekableStream.position();
        if (position == 0L) {
            this.handleBOM();
            l = this.seekableStream.position();
        } else {
            void var1_1;
            l = var1_1;
        }
        return l;
    }

    @Override
    public long previousPosition() {
        return this.position() - (long)this._readBytes();
    }

    @Override
    public char lookAheadAscii() {
        char c;
        long startPosition = this.position();
        try {
            c = this.readAscii();
        }
        finally {
            this.seek(startPosition);
        }
        return c;
    }

    @Override
    public void seek(long position) {
        this.seekableStream.seek(position);
    }

    @Override
    public boolean inMemoryReader() {
        return this.seekableStream.inMemoryStream();
    }

    @Override
    public char read() {
        char c;
        if (this.charBuffer().position() == this.charBuffer().length()) {
            c = this.charBuffer().get();
        } else {
            byte _read = (byte)((InputStream)((Object)this.seekableStream)).read();
            if (_read == -1) {
                this._readBytes_$eq(0);
                c = 65535;
            } else if (_read >= 0) {
                this._readBytes_$eq(1);
                c = (char)_read;
            } else if ((_read & 0xE0) == 192) {
                this._readBytes_$eq(2);
                c = this.decode$1(_read, 1);
            } else if ((_read & 0xF0) == 224) {
                this._readBytes_$eq(3);
                c = this.decode$1(_read, 2);
            } else if ((_read & 0xF8) == 240) {
                this._readBytes_$eq(4);
                c = this.decode$1(_read, 3);
            } else {
                c = (char)65533;
            }
        }
        return c;
    }

    @Override
    public String readEncodedString(long from, long length) {
        byte[] bytes = new byte[(int)length];
        this.seek(from);
        ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        if ((long)this.bigCharBuffer().capacity() < length) {
            this.bigCharBuffer_$eq(CharBuffer.allocate((int)length));
        }
        this.bigCharBuffer().clear();
        CoderResult cr = this.decoder().decode(ByteBuffer.wrap(bytes), this.bigCharBuffer(), true);
        int decodedLength = this.bigCharBuffer().position();
        return new String(this.bigCharBuffer().array(), 0, decodedLength);
    }

    @Override
    public String readAsciiString(long from, long length) {
        byte[] bytes = new byte[(int)length];
        this.seek(from);
        ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    @Override
    public void close() {
        ((InputStream)((Object)this.seekableStream)).close();
    }

    private final char decode$1(byte by, int remainingBytes) {
        char c;
        this.charBuffer().clear();
        byte[] bytes = new byte[remainingBytes + 1];
        bytes[0] = by;
        ((InputStream)((Object)this.seekableStream)).read(bytes, 1, remainingBytes);
        CoderResult result = this.decoder().decode(ByteBuffer.wrap(bytes), this.charBuffer(), true);
        if (!result.isError()) {
            try {
                this.charBuffer().flip();
                c = this.charBuffer().get();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                this.seek(this.position() - (long)remainingBytes);
                c = this.read();
            }
        } else {
            this.seek(this.position() - (long)remainingBytes);
            c = this.read();
        }
        return c;
    }

    public UTF8StreamSourceReader(SeekableStream seekableStream, Charset charset) {
        this.seekableStream = seekableStream;
        this.charset = charset;
        SourceReader.$init$(this);
        this.charBuffer = CharBuffer.allocate(2);
        this.bigCharBuffer = CharBuffer.allocate(8192);
        this._readBytes = 0;
    }
}

