/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.AbstractStreamingBuffer;
import org.mule.runtime.core.internal.streaming.bytes.InputStreamBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStreamBuffer
extends AbstractStreamingBuffer
implements InputStreamBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInputStreamBuffer.class);
    protected final ByteBufferManager bufferManager;
    private final InputStream stream;
    private ReadableByteChannel streamChannel;
    private boolean streamFullyConsumed = false;

    public AbstractInputStreamBuffer(InputStream stream, ByteBufferManager bufferManager) {
        this(stream, AbstractInputStreamBuffer.openStreamChannel(stream), bufferManager);
    }

    public AbstractInputStreamBuffer(InputStream stream, ReadableByteChannel streamChannel, ByteBufferManager bufferManager) {
        this.stream = stream;
        this.streamChannel = streamChannel;
        this.bufferManager = bufferManager;
    }

    protected static ReadableByteChannel openStreamChannel(InputStream stream) {
        return stream != null ? Channels.newChannel(stream) : null;
    }

    public abstract int consumeForwardData() throws IOException;

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.withWriteLock(() -> {
                try {
                    this.doClose();
                    Object var1_1 = null;
                    return var1_1;
                }
                finally {
                    if (this.streamChannel != null) {
                        this.closeSafely(this.streamChannel::close);
                    }
                    if (this.stream != null) {
                        this.closeSafely(this.stream::close);
                    }
                }
            });
        }
    }

    public abstract void doClose();

    @Override
    public final ByteBuffer get(long position, int length) {
        Preconditions.checkState(!this.closed.get(), "Buffer is closed");
        return this.doGet(position, length);
    }

    protected abstract ByteBuffer doGet(long var1, int var3);

    protected int consumeStream(ByteBuffer buffer) throws IOException {
        int result;
        try {
            result = this.streamChannel.read(buffer);
        }
        catch (ClosedByInterruptException cbie) {
            LOGGER.error("Channel interrupted.", (Throwable)cbie);
            throw cbie;
        }
        catch (AsynchronousCloseException ace) {
            LOGGER.error("Channel closed asynchronously.", (Throwable)ace);
            throw ace;
        }
        catch (ClosedChannelException cce) {
            LOGGER.debug("Channel closed.", (Throwable)cce);
            result = -1;
        }
        return result;
    }

    protected boolean deallocate(ByteBuffer byteBuffer) {
        if (byteBuffer != null) {
            this.closeSafely(() -> this.bufferManager.deallocate(byteBuffer));
            return true;
        }
        return false;
    }

    protected boolean isStreamFullyConsumed() {
        return this.streamFullyConsumed;
    }

    protected void streamFullyConsumed() {
        this.streamFullyConsumed = true;
    }

    protected abstract ByteBuffer copy(long var1, int var3);
}

