/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.QNameTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntaxBuilder;
import org.mule.runtime.extension.api.dsl.syntax.DslSyntaxUtils;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DefaultImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;

public class XmlDslSyntaxResolver
implements DslSyntaxResolver {
    private final ExtensionModel extensionModel;
    private final TypeCatalog typeCatalog;
    private final XmlDslModel languageModel;
    private final Map<String, DslElementSyntax> resolvedTypes = new HashMap<String, DslElementSyntax>();
    private final Map<MetadataType, XmlDslModel> importedTypes;
    private final Deque<String> typeResolvingStack = new ArrayDeque<String>();
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    public XmlDslSyntaxResolver(ExtensionModel model, DslResolvingContext context) {
        this.extensionModel = model;
        this.languageModel = model.getXmlDslModel();
        this.typeCatalog = this.getTypeCatalog(model, context);
        this.importedTypes = new DefaultImportTypesStrategy(model, context).getImportedTypes();
    }

    public XmlDslSyntaxResolver(ExtensionModel model, ImportTypesStrategy importTypesStrategy) {
        this.extensionModel = model;
        this.languageModel = model.getXmlDslModel();
        this.typeCatalog = TypeCatalog.getDefault(Collections.singleton(model));
        this.importedTypes = importTypesStrategy.getImportedTypes();
    }

    @Override
    public DslElementSyntax resolve(NamedObject component) {
        String elementName = DslSyntaxUtils.getSanitizedElementName(component);
        return this.computeIfAbsent(this.resolvedTypes, elementName, key -> {
            DslElementSyntaxBuilder dsl = DslElementSyntaxBuilder.create().withElementName(elementName).withNamespace(this.languageModel.getPrefix(), this.languageModel.getNamespace()).supportsTopLevelDeclaration(true).supportsChildDeclaration(true).supportsAttributeDeclaration(false).requiresConfig(ExtensionModelUtils.requiresConfig(this.extensionModel, component));
            if (component instanceof ComponentModel) {
                this.resolveComponentDsl((ComponentModel)component, dsl);
            } else {
                if (component instanceof ParameterizedModel) {
                    this.resolveParameterizedDsl((ParameterizedModel)component, dsl);
                }
                if (component instanceof HasConnectionProviderModels) {
                    ((HasConnectionProviderModels)((Object)component)).getConnectionProviders().forEach(c -> dsl.containing(c.getName(), this.resolve((NamedObject)c)));
                }
            }
            return dsl.build();
        });
    }

    private <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<K, V> mappingFunction) {
        V value = map.get(key);
        if (value == null) {
            value = mappingFunction.apply(key);
            map.put(key, value);
        }
        return value;
    }

    @Override
    public DslElementSyntax resolve(final ParameterModel parameter) {
        final ExpressionSupport expressionSupport = parameter.getExpressionSupport();
        final DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        final ParameterDslConfiguration dslConfig = parameter.getDslConfiguration();
        final boolean isContent = ExtensionModelUtils.isContent(parameter);
        final Reference<String> prefix = new Reference<String>(this.languageModel.getPrefix());
        final Reference<String> namespace = new Reference<String>(this.languageModel.getNamespace());
        final Reference<String> elementName = new Reference<String>(NameUtils.hyphenize(parameter.getName()));
        this.getCustomQName(parameter).ifPresent(qName -> {
            elementName.set(qName.getLocalPart());
            prefix.set(qName.getPrefix());
            namespace.set(qName.getNamespaceURI());
        });
        parameter.getType().accept(new MetadataTypeVisitor(){

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept(this));
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                if (isContent) {
                    this.addContentChildWithNoAttribute();
                } else {
                    builder.supportsAttributeDeclaration(true).supportsChildDeclaration(false).withAttributeName(parameter.getName());
                }
            }

            @Override
            public void visitString(StringType stringType) {
                if (DslSyntaxUtils.isText(parameter) || isContent) {
                    this.addContentChildWithNoAttribute();
                } else {
                    builder.supportsAttributeDeclaration(true).supportsChildDeclaration(false).withAttributeName(parameter.getName());
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                this.defaultVisit(arrayType);
                builder.withNamespace((String)prefix.get(), (String)namespace.get()).withElementName((String)elementName.get());
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(arrayType, expressionSupport, dslConfig, isContent);
                boolean requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(genericType, XmlDslSyntaxResolver.this.typeCatalog);
                if (supportsInline || requiresWrapper) {
                    builder.supportsChildDeclaration(true);
                    if (!isContent) {
                        genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(builder, parameter.getName(), (String)prefix.get(), (String)namespace.get(), false));
                    }
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                XmlDslSyntaxResolver.this.addAttributeName(builder, parameter, isContent, dslConfig);
                builder.withNamespace((String)prefix.get(), (String)namespace.get());
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    XmlDslSyntaxResolver.this.resolveMapDslFromParameter(objectType, builder, isContent, expressionSupport, dslConfig, parameter.getName(), (String)prefix.get(), (String)namespace.get());
                } else {
                    builder.withNamespace((String)prefix.get(), (String)namespace.get()).withElementName((String)elementName.get());
                    XmlDslSyntaxResolver.this.resolveObjectDslFromParameter(parameter, objectType, builder, isContent, dslConfig, expressionSupport, (String)prefix.get(), (String)namespace.get());
                }
            }

            private void addContentChildWithNoAttribute() {
                builder.withNamespace((String)prefix.get(), (String)namespace.get()).withElementName((String)elementName.get()).supportsChildDeclaration(true).supportsAttributeDeclaration(false);
            }
        });
        return builder.build();
    }

    @Override
    public DslElementSyntax resolveInline(ParameterGroupModel group) {
        DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        builder.withNamespace(this.languageModel.getPrefix(), this.languageModel.getNamespace()).withElementName(DslSyntaxUtils.getSanitizedElementName(group)).supportsAttributeDeclaration(false).supportsChildDeclaration(true).supportsTopLevelDeclaration(false);
        group.getParameterModels().forEach(parameter -> builder.containing(parameter.getName(), this.resolve((ParameterModel)parameter)));
        return builder.build();
    }

    @Override
    public Optional<DslElementSyntax> resolve(MetadataType type) {
        return type instanceof ObjectType ? this.resolvePojoDsl((ObjectType)type) : Optional.empty();
    }

    private Optional<DslElementSyntax> resolvePojoDsl(ObjectType type) {
        boolean isSubtype = !this.typeCatalog.getSuperTypes(type).isEmpty();
        boolean requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(type, this.typeCatalog);
        boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration(type, ExpressionSupport.NOT_SUPPORTED) || DslSyntaxUtils.isInstantiable(type) && isSubtype;
        boolean supportTopLevelElement = DslSyntaxUtils.supportTopLevelElement(type);
        if (!(supportsInlineDeclaration || supportTopLevelElement || requiresWrapper || isSubtype)) {
            return Optional.empty();
        }
        Reference<String> prefix = new Reference<String>(this.getPrefix(type));
        Reference<String> namespace = new Reference<String>(this.getNamespace(type));
        Reference<String> elementName = new Reference<String>(NameUtils.getTopLevelTypeName(type));
        this.getCustomQName(type).ifPresent(qName -> {
            prefix.set(qName.getPrefix());
            namespace.set(qName.getNamespaceURI());
            elementName.set(qName.getLocalPart());
        });
        String key = DslSyntaxUtils.getTypeKey(type, prefix.get(), namespace.get());
        if (this.resolvedTypes.containsKey(key)) {
            return Optional.of(this.resolvedTypes.get(key));
        }
        DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create().withNamespace(prefix.get(), namespace.get()).withElementName(elementName.get()).supportsTopLevelDeclaration(supportTopLevelElement).supportsChildDeclaration(supportsInlineDeclaration).supportsAttributeDeclaration(false).asWrappedElement(requiresWrapper);
        String typeId = ExtensionMetadataTypeUtils.getId(type).orElse(null);
        if (typeId != null && !this.typeResolvingStack.contains(typeId)) {
            if (supportTopLevelElement || supportsInlineDeclaration) {
                this.withStackControl(typeId, () -> this.declareFieldsAsChilds(builder, type.getFields(), (String)prefix.get(), (String)namespace.get()));
            }
            DslElementSyntax dsl = builder.build();
            this.resolvedTypes.put(key, dsl);
            return Optional.of(dsl);
        }
        return Optional.of(builder.build());
    }

    private void resolveComponentDsl(ComponentModel component, final DslElementSyntaxBuilder dsl) {
        dsl.supportsTopLevelDeclaration(false);
        this.resolveParameterizedDsl(component, dsl);
        component.accept(new ComponentModelVisitor(){

            @Override
            public void visit(OperationModel operationModel) {
            }

            @Override
            public void visit(SourceModel sourceModel) {
                sourceModel.getSuccessCallback().ifPresent(cb -> XmlDslSyntaxResolver.this.resolveParameterizedDsl(cb, dsl));
                sourceModel.getErrorCallback().ifPresent(cb -> XmlDslSyntaxResolver.this.resolveParameterizedDsl(cb, dsl));
            }

            @Override
            public void visit(ConstructModel model) {
                model.getNestedComponents().forEach(child -> child.accept(new NestableElementModelVisitor(){

                    @Override
                    public void visit(NestedComponentModel component) {
                    }

                    @Override
                    public void visit(NestedChainModel component) {
                    }

                    @Override
                    public void visit(NestedRouteModel component) {
                        dsl.containing(component.getName(), XmlDslSyntaxResolver.this.resolveRouteDsl(component));
                    }
                }));
            }
        });
    }

    private DslElementSyntax resolveRouteDsl(NestedRouteModel route) {
        DslElementSyntaxBuilder dsl = DslElementSyntaxBuilder.create().withElementName(DslSyntaxUtils.getSanitizedElementName(route)).withNamespace(this.languageModel.getPrefix(), this.languageModel.getNamespace()).supportsTopLevelDeclaration(false).supportsChildDeclaration(true).supportsAttributeDeclaration(false).requiresConfig(false);
        this.resolveParameterizedDsl(route, dsl);
        return dsl.build();
    }

    private void resolveObjectDslFromParameter(ParameterModel parameter, ObjectType objectType, DslElementSyntaxBuilder builder, boolean isContent, ParameterDslConfiguration dslConfig, ExpressionSupport expressionSupport, String prefix, String namespace) {
        boolean requiresWrapper;
        boolean supportsInline;
        boolean supportsTopLevel;
        if (ExtensionModelUtils.isInfrastructure(parameter)) {
            supportsTopLevel = dslConfig.allowTopLevelDefinition();
            supportsInline = dslConfig.allowsInlineDefinition();
            requiresWrapper = false;
        } else {
            supportsTopLevel = DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, dslConfig);
            supportsInline = DslSyntaxUtils.supportsInlineDeclaration(objectType, expressionSupport, dslConfig, isContent);
            requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(objectType, this.typeCatalog);
        }
        builder.supportsTopLevelDeclaration(supportsTopLevel);
        if ((supportsInline || requiresWrapper) && dslConfig.allowsInlineDefinition()) {
            builder.supportsChildDeclaration(true);
            if (requiresWrapper) {
                builder.asWrappedElement(true);
            } else if (!isContent) {
                this.declareFieldsAsChilds(builder, objectType.getFields(), prefix, namespace);
            }
        }
    }

    private void resolveMapDslFromParameter(ObjectType objectType, DslElementSyntaxBuilder builder, boolean isContent, ExpressionSupport expressionSupport, ParameterDslConfiguration dslModel, String name, String namespace, String namespaceUri) {
        String parameterName = isContent ? name : NameUtils.pluralize(name);
        builder.withElementName(NameUtils.hyphenize(parameterName)).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration(objectType, expressionSupport, dslModel, isContent));
        if (!isContent) {
            objectType.getOpenRestriction().ifPresent(type -> type.accept(this.getMapValueTypeVisitor(builder, name, namespace, namespaceUri, dslModel)));
        }
    }

    private void resolveParameterizedDsl(ParameterizedModel component, DslElementSyntaxBuilder dsl) {
        List inlineGroupedParameters = component.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).peek(group -> dsl.containing(group.getName(), this.resolveInline((ParameterGroupModel)group))).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        component.getAllParameterModels().stream().filter(p -> !inlineGroupedParameters.contains(p)).forEach(parameter -> dsl.containing(parameter.getName(), this.resolve((ParameterModel)parameter)));
    }

    private MetadataTypeVisitor getArrayItemTypeVisitor(final DslElementSyntaxBuilder listBuilder, final String parameterName, final String namespace, final String namespaceUri, final boolean asItem) {
        return new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    this.defaultVisit(objectType);
                    return;
                }
                if (DslSyntaxUtils.typeRequiresWrapperElement(objectType, XmlDslSyntaxResolver.this.typeCatalog)) {
                    listBuilder.withGeneric(objectType, DslElementSyntaxBuilder.create().withNamespace(XmlDslSyntaxResolver.this.getPrefix(objectType), XmlDslSyntaxResolver.this.getNamespace(objectType)).withElementName(NameUtils.getTopLevelTypeName(objectType)).supportsAttributeDeclaration(false).supportsChildDeclaration(DslSyntaxUtils.supportsInlineDeclaration(objectType, ExpressionSupport.NOT_SUPPORTED)).asWrappedElement(true).supportsTopLevelDeclaration(DslSyntaxUtils.supportTopLevelElement((MetadataType)objectType, ParameterDslConfiguration.getDefaultInstance())).build());
                } else if (DslSyntaxUtils.isValidBean(objectType)) {
                    listBuilder.withGeneric(objectType, XmlDslSyntaxResolver.this.resolve(objectType).get());
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder genericBuilder = DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(XmlDslSyntaxResolver.this.resolveItemName(parameterName, asItem)).supportsAttributeDeclaration(false);
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED);
                boolean requiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(genericType, XmlDslSyntaxResolver.this.typeCatalog);
                if (supportsInline || requiresWrapper) {
                    genericBuilder.supportsChildDeclaration(true);
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(genericBuilder, parameterName, namespace, namespaceUri, true));
                }
                listBuilder.withGeneric(arrayType, genericBuilder.build());
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                listBuilder.withGeneric(metadataType, DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(XmlDslSyntaxResolver.this.resolveItemName(parameterName, asItem)).supportsAttributeDeclaration(false).supportsChildDeclaration(true).containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build()).build());
            }
        };
    }

    private MetadataTypeVisitor getMapValueTypeVisitor(final DslElementSyntaxBuilder mapBuilder, final String parameterName, final String namespace, final String namespaceUri, final ParameterDslConfiguration dslModel) {
        return new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                mapBuilder.withGeneric(metadataType, this.createBaseValueEntryDefinition().containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build()).build());
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    this.defaultVisit(objectType);
                    return;
                }
                boolean supportsInlineDeclaration = DslSyntaxUtils.supportsInlineDeclaration(objectType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean requiresWrapperElement = DslSyntaxUtils.typeRequiresWrapperElement(objectType, XmlDslSyntaxResolver.this.typeCatalog);
                if (supportsInlineDeclaration || requiresWrapperElement) {
                    DslElementSyntaxBuilder valueEntry = this.createBaseValueEntryDefinition();
                    String namespace2 = XmlDslSyntaxResolver.this.getPrefix(objectType);
                    String namespaceUri2 = XmlDslSyntaxResolver.this.getNamespace(objectType);
                    DslElementSyntaxBuilder innerPojoDsl = DslElementSyntaxBuilder.create().withAttributeName("value").withNamespace(namespace2, namespaceUri2);
                    if (supportsInlineDeclaration) {
                        innerPojoDsl.withElementName(NameUtils.getTopLevelTypeName(objectType)).supportsChildDeclaration(true);
                        ExtensionMetadataTypeUtils.getId(objectType).ifPresent(id -> XmlDslSyntaxResolver.this.withStackControl(id, () -> XmlDslSyntaxResolver.this.declareFieldsAsChilds(innerPojoDsl, objectType.getFields(), namespace2, namespaceUri2)));
                    } else {
                        innerPojoDsl.asWrappedElement(true);
                    }
                    valueEntry.containing("value", innerPojoDsl.build());
                    mapBuilder.withGeneric(objectType, valueEntry.build());
                } else {
                    this.defaultVisit(objectType);
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder valueEntry = this.createBaseValueEntryDefinition().containing("value", DslElementSyntaxBuilder.create().withAttributeName("value").build());
                MetadataType genericType = arrayType.getType();
                boolean genericSupportsInline = DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED, dslModel, false);
                boolean genericRequiresWrapper = DslSyntaxUtils.typeRequiresWrapperElement(genericType, XmlDslSyntaxResolver.this.typeCatalog);
                if (genericSupportsInline || genericRequiresWrapper) {
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(valueEntry, parameterName, namespace, namespaceUri, true));
                }
                mapBuilder.withGeneric(arrayType, valueEntry.build());
            }

            private DslElementSyntaxBuilder createBaseValueEntryDefinition() {
                return DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(NameUtils.hyphenize(NameUtils.singularize(parameterName))).supportsAttributeDeclaration(false).supportsChildDeclaration(true).containing("key", DslElementSyntaxBuilder.create().withAttributeName("key").build());
            }
        };
    }

    private void addBeanDeclarationSupport(ObjectType objectType, Collection<ObjectFieldType> childFields, DslElementSyntaxBuilder builder, String namespace, String namespaceUri, boolean introspectObjectFields) {
        boolean supportsChildDeclaration = DslSyntaxUtils.supportsInlineDeclaration(objectType, ExpressionSupport.SUPPORTED);
        boolean supportsTopDeclaration = DslSyntaxUtils.supportTopLevelElement(objectType);
        builder.supportsChildDeclaration(supportsChildDeclaration).supportsTopLevelDeclaration(supportsTopDeclaration).asWrappedElement(DslSyntaxUtils.typeRequiresWrapperElement(objectType, this.typeCatalog));
        if (introspectObjectFields && (supportsChildDeclaration || supportsTopDeclaration)) {
            this.declareFieldsAsChilds(builder, childFields, namespace, namespaceUri);
        }
    }

    private MetadataTypeVisitor getObjectFieldVisitor(final DslElementSyntaxBuilder objectFieldBuilder, final String fieldName, final String fieldElementName, final String ownerNamespace, final String ownerNamespaceUri) {
        return new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                objectFieldBuilder.withAttributeName(fieldName).supportsAttributeDeclaration(true).supportsTopLevelDeclaration(false).supportsChildDeclaration(false).requiresConfig(false);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                objectFieldBuilder.withAttributeName(fieldName);
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    this.handleMapObject(objectType);
                } else {
                    objectFieldBuilder.withElementName(fieldElementName).withNamespace(XmlDslSyntaxResolver.this.getPrefix(objectType, ownerNamespace), XmlDslSyntaxResolver.this.getNamespace(objectType, ownerNamespaceUri));
                    String typeId = ExtensionMetadataTypeUtils.getId(objectType).orElse(null);
                    if (typeId != null && !XmlDslSyntaxResolver.this.typeResolvingStack.contains(typeId)) {
                        XmlDslSyntaxResolver.this.withStackControl(typeId, () -> {
                            List fields = objectType.getFields().stream().filter(f -> ExtensionMetadataTypeUtils.getId(f.getValue()).map(id -> !XmlDslSyntaxResolver.this.typeResolvingStack.contains(id)).orElse(true)).collect(Collectors.toList());
                            XmlDslSyntaxResolver.this.addBeanDeclarationSupport(objectType, fields, objectFieldBuilder, ownerNamespace, ownerNamespaceUri, true);
                        });
                    } else {
                        XmlDslSyntaxResolver.this.addBeanDeclarationSupport(objectType, Collections.emptyList(), objectFieldBuilder, ownerNamespace, ownerNamespaceUri, false);
                    }
                }
            }

            private void handleMapObject(ObjectType objectType) {
                objectFieldBuilder.withElementName(NameUtils.hyphenize(NameUtils.pluralize(fieldName))).withNamespace(ownerNamespace, ownerNamespaceUri);
                objectFieldBuilder.supportsChildDeclaration(true);
                objectFieldBuilder.withGeneric(XmlDslSyntaxResolver.this.typeLoader.load((Type)((Object)String.class)), DslElementSyntaxBuilder.create().withAttributeName("key").build());
                objectType.getOpenRestriction().ifPresent(type -> type.accept(XmlDslSyntaxResolver.this.getMapValueTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, ParameterDslConfiguration.getDefaultInstance())));
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(fieldElementName).withNamespace(ownerNamespace, ownerNamespaceUri);
                MetadataType genericType = arrayType.getType();
                if (DslSyntaxUtils.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    genericType.accept(XmlDslSyntaxResolver.this.getArrayItemTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, false));
                }
            }
        };
    }

    private void declareFieldsAsChilds(DslElementSyntaxBuilder objectBuilder, Collection<ObjectFieldType> fields, String namespace, String namespaceUri) {
        fields.forEach(field -> {
            DslElementSyntaxBuilder fieldBuilder = DslElementSyntaxBuilder.create();
            String childName = field.getKey().getName().getLocalPart();
            MetadataType fieldValue = field.getValue();
            Reference<String> fieldPrefix = new Reference<String>(namespace);
            Reference<String> fieldNamespaceUri = new Reference<String>(namespaceUri);
            Reference<String> elementName = new Reference<String>(NameUtils.hyphenize(childName));
            if (DslSyntaxUtils.isFlattened(field, fieldValue)) {
                this.declareFieldsAsChilds(objectBuilder, ((ObjectType)fieldValue).getFields(), fieldPrefix.get(), fieldNamespaceUri.get());
            } else {
                if (DslSyntaxUtils.isText(field)) {
                    fieldBuilder.supportsAttributeDeclaration(false).supportsChildDeclaration(true).withElementName(elementName.get()).withNamespace(fieldPrefix.get(), fieldNamespaceUri.get());
                } else {
                    this.getCustomQName(fieldValue).ifPresent(qName -> {
                        elementName.set(qName.getLocalPart());
                        fieldPrefix.set(qName.getPrefix());
                        fieldNamespaceUri.set(qName.getNamespaceURI());
                    });
                    fieldValue.accept(this.getObjectFieldVisitor(fieldBuilder, childName, elementName.get(), fieldPrefix.get(), fieldNamespaceUri.get()));
                    fieldBuilder.supportsAttributeDeclaration(DslSyntaxUtils.supportAttributeDeclaration(field));
                }
                objectBuilder.containing(childName, fieldBuilder.build());
            }
        });
    }

    private void addAttributeName(DslElementSyntaxBuilder builder, ParameterModel parameter, boolean isContent, ParameterDslConfiguration dslModel) {
        if (this.supportsAttributeDeclaration(parameter, isContent, dslModel)) {
            builder.withAttributeName(parameter.getName());
        } else {
            builder.supportsAttributeDeclaration(false);
        }
    }

    private boolean supportsAttributeDeclaration(ParameterModel parameter, boolean isContent, ParameterDslConfiguration dslModel) {
        return !isContent && (dslModel.allowsReferences() || !ExpressionSupport.NOT_SUPPORTED.equals((Object)parameter.getExpressionSupport()));
    }

    private String getPrefix(MetadataType type) {
        return this.getPrefix(type, this.languageModel.getPrefix());
    }

    private String getPrefix(MetadataType type, String prefix) {
        XmlDslModel originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getPrefix() : prefix;
    }

    private String getNamespace(MetadataType type) {
        return this.getNamespace(type, this.languageModel.getNamespace());
    }

    private String getNamespace(MetadataType type, String defaultNamespace) {
        XmlDslModel originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getNamespace() : defaultNamespace;
    }

    private String resolveItemName(String parameterName, boolean forceItemize) {
        String singularizedName = NameUtils.singularize(parameterName);
        return forceItemize || parameterName.equals(singularizedName) ? NameUtils.itemize(singularizedName) : NameUtils.hyphenize(singularizedName);
    }

    private TypeCatalog getTypeCatalog(ExtensionModel model, DslResolvingContext context) {
        return context.getExtension(model.getName()).isPresent() ? context.getTypeCatalog() : TypeCatalog.getDefault((Set<ExtensionModel>)ImmutableSet.builder().add((Object)model).addAll(context.getExtensions()).build());
    }

    private void withStackControl(String stackId, Runnable action) {
        if (!this.typeResolvingStack.contains(stackId)) {
            this.typeResolvingStack.push(stackId);
            action.run();
            this.typeResolvingStack.pop();
        }
    }

    private Optional<QName> getCustomQName(ParameterModel parameter) {
        return parameter.getModelProperty(QNameModelProperty.class).map(QNameModelProperty::getValue);
    }

    private Optional<QName> getCustomQName(MetadataType type) {
        return type.getAnnotation(QNameTypeAnnotation.class).map(QNameTypeAnnotation::getValue);
    }
}

