/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.annotation.privileged.DeclarationEnrichers;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.module.extension.api.loader.ModelLoaderDelegate;
import org.mule.runtime.module.extension.api.loader.ModelLoaderDelegateFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.internal.loader.enricher.BackPressureDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.BooleanParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ClusterSupportEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ConnectionDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DefaultEncodingDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DisplayDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.DynamicMetadataDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ErrorsDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionDescriptionsEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ExtensionsErrorsDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ImportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaConfigurationDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaExportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaOAuthDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaPrivilegedExportedTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.JavaXmlDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.MimeTypeParametersDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.NotificationsDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ObjectStoreParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ParameterAllowedStereotypesDeclarionEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ParameterDslDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ParameterLayoutOrderDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.PollingSourceDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.RedeliveryPolicyDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.RefNameDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.SubTypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.ValueProvidersParameterDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.StereotypesDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.validation.ComponentLocationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ConfigurationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.InjectedFieldsModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.InputParametersTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.JavaSubtypesModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.MediaTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.MetadataComponentModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.NullSafeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OAuthConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OperationParametersTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.OperationReturnTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.PagedOperationModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterGroupModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterPluralNameModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ParameterTypeModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.PrivilegedApiValidator;
import org.mule.runtime.module.extension.internal.loader.validation.SourceCallbacksModelValidator;
import org.mule.runtime.module.extension.internal.loader.validation.ValueProviderModelValidator;

public class AbstractJavaExtensionModelLoader
extends ExtensionModelLoader {
    public static final String TYPE_PROPERTY_NAME = "type";
    public static final String EXTENSION_TYPE = "EXTENSION_TYPE";
    public static final String VERSION = "version";
    private final List<ExtensionModelValidator> customValidators = Collections.unmodifiableList(Arrays.asList(new ConfigurationModelValidator(), new ConnectionProviderModelValidator(), new InputParametersTypeModelValidator(), new JavaSubtypesModelValidator(), new MediaTypeModelValidator(), new MetadataComponentModelValidator(), new NullSafeModelValidator(), new OperationReturnTypeModelValidator(), new OperationParametersTypeModelValidator(), new SourceCallbacksModelValidator(), new PagedOperationModelValidator(), new ParameterGroupModelValidator(), new ParameterTypeModelValidator(), new ParameterPluralNameModelValidator(), new OAuthConnectionProviderModelValidator(), new ValueProviderModelValidator(), new PrivilegedApiValidator(), new ComponentLocationModelValidator(), new InjectedFieldsModelValidator()));
    private final List<DeclarationEnricher> customDeclarationEnrichers = Collections.unmodifiableList(Arrays.asList(new JavaXmlDeclarationEnricher(), new BooleanParameterDeclarationEnricher(), new RefNameDeclarationEnricher(), new DefaultEncodingDeclarationEnricher(), new ConnectionDeclarationEnricher(), new ErrorsDeclarationEnricher(), new NotificationsDeclarationEnricher(), new JavaExportedTypesDeclarationEnricher(), new StereotypesDeclarationEnricher(), new ExtensionsErrorsDeclarationEnricher(), new MimeTypeParametersDeclarationEnricher(), new DisplayDeclarationEnricher(), new DynamicMetadataDeclarationEnricher(), new ImportedTypesDeclarationEnricher(), new JavaConfigurationDeclarationEnricher(), new JavaPrivilegedExportedTypesDeclarationEnricher(), new JavaOAuthDeclarationEnricher(), new RedeliveryPolicyDeclarationEnricher(), new SubTypesDeclarationEnricher(), new ExtensionDescriptionsEnricher(), new ValueProvidersParameterDeclarationEnricher(), new ParameterAllowedStereotypesDeclarionEnricher(), new ParameterLayoutOrderDeclarationEnricher(), new ClusterSupportEnricher(), new ParameterLayoutOrderDeclarationEnricher(), new BackPressureDeclarationEnricher(), new ObjectStoreParameterDeclarationEnricher(), new PollingSourceDeclarationEnricher(), new ParameterDslDeclarationEnricher()));
    private final String id;
    private ModelLoaderDelegateFactory factory;

    @Deprecated
    public AbstractJavaExtensionModelLoader(String id, BiFunction<Class<?>, String, ModelLoaderDelegate> delegate) {
        this(id, (ExtensionElement extensionElement, String version) -> (ModelLoaderDelegate)delegate.apply(extensionElement.getDeclaringClass().get(), version));
    }

    public AbstractJavaExtensionModelLoader(String id, ModelLoaderDelegateFactory factory) {
        this.id = id;
        this.factory = factory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected void configureContextBeforeDeclaration(ExtensionLoadingContext context) {
        context.addCustomValidators(this.customValidators);
        context.addCustomDeclarationEnrichers(this.customDeclarationEnrichers);
        context.addCustomDeclarationEnrichers(this.getPrivilegedDeclarationEnrichers(context));
    }

    @Override
    protected void declareExtension(ExtensionLoadingContext context) {
        ExtensionElement extensionType = this.getExtensionType(context);
        String version = (String)context.getParameter(VERSION).orElseThrow(() -> new IllegalArgumentException("version not specified"));
        this.factory.getLoader(extensionType, version).declare(context);
    }

    private Collection<DeclarationEnricher> getPrivilegedDeclarationEnrichers(ExtensionLoadingContext context) {
        ExtensionElement extensionType = this.getExtensionType(context);
        if (extensionType.getDeclaringClass().isPresent()) {
            try {
                ClassLoader extensionClassLoader = context.getExtensionClassLoader();
                Class<?> annotation = extensionClassLoader.loadClass(DeclarationEnrichers.class.getName());
                return extensionType.getAnnotation(annotation).map(enrichers -> ClassUtils.withContextClassLoader(extensionClassLoader, () -> Arrays.stream(enrichers.value()).map(this::instantiateOrFail).collect(Collectors.toList()))).orElse(Collections.emptyList());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    private ExtensionElement getExtensionType(ExtensionLoadingContext context) {
        return context.getParameter(EXTENSION_TYPE).orElseGet(() -> {
            String type = (String)context.getParameter(TYPE_PROPERTY_NAME).get();
            try {
                ClassLoader extensionClassLoader = context.getExtensionClassLoader();
                return new ExtensionTypeWrapper(ClassUtils.loadClass(type, extensionClassLoader), new DefaultExtensionsTypeLoaderFactory().createTypeLoader(extensionClassLoader));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Class '%s' cannot be loaded", type), e);
            }
        });
    }

    private <R> R instantiateOrFail(Class<R> clazz) {
        try {
            return ClassUtils.instantiateClass(clazz, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error instantiating class: [" + clazz + "].", e);
        }
    }
}

