/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.correlation;

import java.text.MessageFormat;
import java.util.Optional;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.routing.AggregationException;
import org.mule.runtime.core.internal.routing.EventGroup;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.privileged.event.DefaultMuleSession;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionCorrelatorCallback
implements EventCorrelatorCallback {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MuleContext muleContext;
    private final String storePrefix;

    public CollectionCorrelatorCallback(MuleContext muleContext, String storePrefix) {
        this.muleContext = muleContext;
        this.storePrefix = storePrefix;
    }

    @Override
    public CoreEvent aggregateEvents(EventGroup events) throws AggregationException {
        return events.getMessageCollectionEvent();
    }

    protected MuleSession getMergedSession(PrivilegedEvent[] events) {
        DefaultMuleSession session = new DefaultMuleSession(events[0].getSession());
        for (int i = 1; i < events.length; ++i) {
            for (String name : events[i].getSession().getPropertyNamesAsSet()) {
                session.setProperty(name, events[i].getSession().getProperty(name));
            }
        }
        return session;
    }

    @Override
    public EventGroup createEventGroup(CoreEvent event, Object groupId) {
        return new EventGroup(groupId, this.muleContext, event.getGroupCorrelation().isPresent() ? (event.getGroupCorrelation().get().getGroupSize().isPresent() ? Optional.of(event.getGroupCorrelation().get().getGroupSize().getAsInt()) : Optional.empty()) : Optional.empty(), this.storePrefix);
    }

    @Override
    public boolean shouldAggregateEvents(EventGroup events) {
        if (!events.expectedSize().isPresent()) {
            this.logger.warn("GroupCorrelation Group Size not set, but correlation aggregator is being used. Message is being forwarded as is");
            return true;
        }
        Integer size = events.expectedSize().get();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format("GroupCorrelation group size is {0}. Current event group size is {1} for group ID: {2}", size, events.size(), events.getGroupId()));
        }
        return size.intValue() == events.size();
    }
}

