/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming;

import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.core.internal.streaming.CursorContext;
import org.mule.runtime.core.internal.streaming.CursorManager;

public abstract class ManagedCursorProvider<T extends Cursor>
implements CursorProvider<T> {
    private final CursorProvider<T> delegate;
    private final CursorManager cursorManager;
    private final CursorContext cursorContext;

    protected ManagedCursorProvider(CursorContext cursorContext, CursorManager cursorManager) {
        this.delegate = cursorContext.getCursorProvider();
        this.cursorContext = cursorContext;
        this.cursorManager = cursorManager;
    }

    @Override
    public final T openCursor() {
        T cursor = this.delegate.openCursor();
        this.cursorManager.onOpen((Cursor)cursor, this.cursorContext);
        return this.managedCursor(cursor, this.cursorContext);
    }

    protected abstract T managedCursor(T var1, CursorContext var2);

    @Override
    public void releaseResources() {
        this.delegate.releaseResources();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    protected CursorManager getCursorManager() {
        return this.cursorManager;
    }
}

