/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.internal.streaming.DefaultMemoryManager;
import org.mule.runtime.core.internal.streaming.MemoryManager;
import org.mule.runtime.core.internal.streaming.bytes.ByteStreamingConstants;
import org.mule.runtime.core.internal.streaming.bytes.MaxStreamingMemoryExceededException;
import org.mule.runtime.core.internal.util.ConcurrencyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingByteBufferManager
implements ByteBufferManager,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoolingByteBufferManager.class);
    private static final int MAX_IDLE = Runtime.getRuntime().availableProcessors();
    static final double MAX_STREAMING_PERCENTILE = 0.7;
    private final AtomicLong streamingMemory = new AtomicLong(0L);
    private final long maxStreamingMemory;
    private final long waitTimeoutMillis;
    private BufferPool defaultSizePool;
    private final LoadingCache<Integer, BufferPool> customSizePools = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> {
        block2: {
            try {
                ((BufferPool)notification.getValue()).close();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("Found exception trying to dispose buffer pool for capacity " + notification.getKey(), (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<Integer, BufferPool>(){

        public BufferPool load(Integer capacity) {
            return PoolingByteBufferManager.this.newBufferPool(capacity);
        }
    });
    private ExecutorService allocationScheduler;

    public PoolingByteBufferManager(ExecutorService allocationScheduler) {
        this(allocationScheduler, new DefaultMemoryManager(), 4000L);
    }

    public PoolingByteBufferManager(ExecutorService allocationScheduler, MemoryManager memoryManager, long waitTimeoutMillis) {
        this.allocationScheduler = allocationScheduler;
        this.maxStreamingMemory = this.calculateMaxStreamingMemory(memoryManager);
        this.waitTimeoutMillis = waitTimeoutMillis;
        this.defaultSizePool = this.newBufferPool(ByteStreamingConstants.DEFAULT_BUFFER_BUCKET_SIZE);
    }

    private long calculateMaxStreamingMemory(MemoryManager memoryManager) {
        String maxMemoryProperty = System.getProperty("mule.max.streaming.memory");
        if (maxMemoryProperty == null) {
            return Math.round((double)memoryManager.getMaxMemory() * 0.7);
        }
        try {
            return Long.valueOf(maxMemoryProperty);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid value for system property '%s'. A memory size (in bytes) was expected, got '%s' instead", "mule.max.streaming.memory", maxMemoryProperty));
        }
    }

    private BufferPool newBufferPool(Integer capacity) {
        return ClassUtils.withContextClassLoader(PoolingByteBufferManager.class.getClassLoader(), () -> this.allocationScheduler.submit(() -> new BufferPool(capacity)).get());
    }

    private BufferPool getBufferPool(int capacity) {
        return capacity == ByteStreamingConstants.DEFAULT_BUFFER_BUCKET_SIZE ? this.defaultSizePool : (BufferPool)this.customSizePools.getUnchecked((Object)capacity);
    }

    @Override
    public ByteBuffer allocate(int capacity) {
        try {
            return this.getBufferPool(capacity).take();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not allocate byte buffer. " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void deallocate(ByteBuffer byteBuffer) {
        int capacity = byteBuffer.capacity();
        BufferPool pool = this.getBufferPool(capacity);
        if (pool != null) {
            try {
                pool.returnBuffer(byteBuffer);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not deallocate buffer of capacity " + capacity), (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        block5: {
            block4: {
                try {
                    this.defaultSizePool.close();
                }
                catch (Exception e) {
                    if (!LOGGER.isWarnEnabled()) break block4;
                    LOGGER.warn("Error disposing default capacity byte buffers pool", (Throwable)e);
                }
            }
            try {
                this.customSizePools.invalidateAll();
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn("Error disposing mixed capacity byte buffers pool", (Throwable)e);
            }
        }
    }

    private class BufferPool {
        private final int bufferCapacity;
        private final ObjectPool<ByteBuffer> pool;
        private final Lock lock = new ReentrantLock();
        private final Condition poolNotFull = this.lock.newCondition();

        private BufferPool(final int bufferCapacity) {
            this.bufferCapacity = bufferCapacity;
            GenericObjectPoolConfig config = new GenericObjectPoolConfig();
            config.setMaxIdle(MAX_IDLE);
            config.setMaxTotal(-1);
            config.setBlockWhenExhausted(false);
            config.setTimeBetweenEvictionRunsMillis(TimeUnit.MINUTES.toMillis(5L));
            config.setTestOnBorrow(false);
            config.setTestOnReturn(false);
            config.setTestWhileIdle(false);
            config.setTestOnCreate(false);
            config.setJmxEnabled(false);
            this.pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<ByteBuffer>(){

                public ByteBuffer create() throws Exception {
                    if (PoolingByteBufferManager.this.streamingMemory.addAndGet(bufferCapacity) <= PoolingByteBufferManager.this.maxStreamingMemory) {
                        return ByteBuffer.allocate(bufferCapacity);
                    }
                    PoolingByteBufferManager.this.streamingMemory.addAndGet(-bufferCapacity);
                    throw new MaxStreamingMemoryExceededException(I18nMessageFactory.createStaticMessage(String.format("Max streaming memory limit of %d bytes was exceeded", PoolingByteBufferManager.this.maxStreamingMemory)));
                }

                public PooledObject<ByteBuffer> wrap(ByteBuffer obj) {
                    return new DefaultPooledObject((Object)obj);
                }

                public void activateObject(PooledObject<ByteBuffer> p) throws Exception {
                    ((ByteBuffer)p.getObject()).clear();
                }

                public void destroyObject(PooledObject<ByteBuffer> p) throws Exception {
                    if (PoolingByteBufferManager.this.streamingMemory.addAndGet(-bufferCapacity) < PoolingByteBufferManager.this.maxStreamingMemory) {
                        BufferPool.this.signalPoolNotFull();
                    }
                }
            }, config);
        }

        private ByteBuffer take() throws Exception {
            ByteBuffer buffer = null;
            do {
                try {
                    buffer = (ByteBuffer)this.pool.borrowObject();
                }
                catch (MaxStreamingMemoryExceededException e) {
                    this.signal(() -> {
                        while (PoolingByteBufferManager.this.streamingMemory.get() >= PoolingByteBufferManager.this.maxStreamingMemory) {
                            if (this.poolNotFull.await(PoolingByteBufferManager.this.waitTimeoutMillis, TimeUnit.MILLISECONDS)) continue;
                            throw e;
                        }
                    });
                }
            } while (buffer == null);
            return buffer;
        }

        private void returnBuffer(ByteBuffer buffer) throws Exception {
            this.pool.returnObject((Object)buffer);
            this.signalPoolNotFull();
        }

        private void signalPoolNotFull() {
            this.signal(this.poolNotFull::signal);
        }

        private void close() {
            PoolingByteBufferManager.this.streamingMemory.addAndGet(-this.bufferCapacity * (this.pool.getNumActive() + this.pool.getNumIdle()));
            try {
                this.pool.close();
            }
            finally {
                this.signal(this.poolNotFull::signalAll);
            }
        }

        private void signal(CheckedRunnable task) {
            ConcurrencyUtils.withLock(this.lock, task);
        }
    }
}

