/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ToolingDomainClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<DomainClassLoaderBuilder> {
    private final ArtifactClassLoader parentClassLoader;
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;

    public ToolingDomainClassLoaderBuilder(ArtifactClassLoader parentClassLoader, DeployableArtifactClassLoaderFactory<DomainDescriptor> artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.parentClassLoader = parentClassLoader;
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    public ToolingArtifactClassLoader build() throws IOException {
        ArtifactClassLoader domainClassLoader = super.build();
        ClassLoader parent = domainClassLoader.getClassLoader().getParent();
        if (!(parent instanceof RegionClassLoader)) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("The parent of the current owner must be of type '%s' but found '%s'", RegionClassLoader.class.getName(), parent.getClass().getName())));
        }
        RegionClassLoader regionClassLoader = (RegionClassLoader)parent;
        return new ToolingArtifactClassLoader(regionClassLoader, domainClassLoader);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return ToolingDomainClassLoaderBuilder.getDomainId(artifactDescriptor.getName());
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)domainName), "domainName cannot be empty");
        return "/tooling-domain/" + domainName;
    }
}

