/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;

public final class ReconnectionStrategyTypeBuilder
extends InfrastructureTypeBuilder {
    public static final String COUNT = "count";
    public static final String FREQUENCY = "frequency";
    public static final String RECONNECT_ALIAS = "reconnect";
    public static final String RECONNECT_FOREVER_ALIAS = "reconnect-forever";
    public static final String BLOCKING = "blocking";
    public static final String RECONNECTION_STRATEGY = "ReconnectionStrategy";
    public static final String RECONNECTION_CONFIG = "Reconnection";

    public MetadataType buildReconnectionConfigType() {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        ObjectTypeBuilder type = BaseTypeBuilder.create(MetadataFormat.JAVA).objectType().id(RECONNECTION_CONFIG).with(new InfrastructureTypeAnnotation());
        this.addBooleanField(type, typeBuilder, "failsDeployment", "When the application is deployed, a connectivity test is performed on all connectors. If set to true, deployment will fail if the test doesn't pass after exhausting the associated reconnection strategy", false);
        type.addField().key("reconnectionStrategy").description("The reconnection strategy to use").value(this.buildReconnectionStrategyType());
        return type.build();
    }

    public MetadataType buildReconnectionStrategyType() {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        return BaseTypeBuilder.create(MetadataFormat.JAVA).unionType().id(RECONNECTION_STRATEGY).of(this.getSimpleRetryType(typeBuilder)).of(this.getForeverRetryType(typeBuilder)).with(new InfrastructureTypeAnnotation()).build();
    }

    private TypeBuilder getSimpleRetryType(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder retryType = typeBuilder.objectType().id(RECONNECT_ALIAS).with(new InfrastructureTypeAnnotation());
        this.addFrequencyField(retryType, typeBuilder);
        this.addIntField(retryType, typeBuilder, COUNT, "How many reconnection attempts to make", 2);
        return retryType;
    }

    private void addFrequencyField(ObjectTypeBuilder retryType, BaseTypeBuilder typeBuilder) {
        this.addLongField(retryType, typeBuilder, FREQUENCY, "How often (in ms) to reconnect", 2000L);
    }

    private TypeBuilder getForeverRetryType(BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder retryType = typeBuilder.objectType().id(RECONNECT_FOREVER_ALIAS).with(new InfrastructureTypeAnnotation());
        this.addFrequencyField(retryType, typeBuilder);
        return retryType;
    }
}

