/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PagingProviderWrapper<C, T>
implements PagingProvider<C, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagingProviderWrapper.class);
    private final PagingProvider<C, T> delegate;
    private boolean closed = false;

    public PagingProviderWrapper(PagingProvider<C, T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close(C connection) throws MuleException {
        this.closed = true;
        this.delegate.close(connection);
    }

    private void handleCloseException(Throwable t) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Exception was found trying to close paging delegate. Execution will continue", t);
        }
    }

    @Override
    public List<T> getPage(C connection) {
        if (this.closed) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("paging delegate is closed. Returning null");
            }
            return null;
        }
        List<T> page = this.delegate.getPage(connection);
        if (CollectionUtils.isEmpty(page)) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Empty page was obtained. Closing delegate since this means that the data source has been consumed");
                }
                this.close(connection);
            }
            catch (Exception e) {
                this.handleCloseException(e);
            }
        }
        return page;
    }

    @Override
    public Optional<Integer> getTotalResults(C connection) {
        Optional<Integer> size = this.delegate.getTotalResults(connection);
        return size != null ? size : Optional.empty();
    }

    @Override
    public boolean useStickyConnections() {
        return this.delegate.useStickyConnections();
    }
}

