/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import org.mule.tools.api.classloader.ArtifactCustomJsonSerializer;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.AppClassLoaderModel;
import org.mule.tools.api.classloader.model.Artifact;

public class AppClassLoaderModelJsonSerializer
extends ClassLoaderModelJsonSerializer {
    public static AppClassLoaderModel deserialize(File classLoaderModelDescriptor) {
        try {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().create();
            FileReader reader = new FileReader(classLoaderModelDescriptor);
            AppClassLoaderModel classLoaderModel = (AppClassLoaderModel)gson.fromJson((Reader)reader, AppClassLoaderModel.class);
            ((Reader)reader).close();
            return classLoaderModel;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create classloader-model.json", e);
        }
    }

    public static class AppClassLoaderModelCustomJsonSerializer
    implements JsonSerializer<AppClassLoaderModel> {
        public JsonElement serialize(AppClassLoaderModel classLoaderModel, Type type, JsonSerializationContext jsonSerializationContext) {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().registerTypeAdapter(Artifact.class, (Object)new ArtifactCustomJsonSerializer()).create();
            JsonObject jsonObject = (JsonObject)gson.toJsonTree((Object)classLoaderModel);
            if (classLoaderModel.getAdditionalPluginDependencies().map(List::isEmpty).orElse(false).booleanValue()) {
                jsonObject.remove("additionalPluginDependencies");
            }
            return jsonObject;
        }
    }
}

