/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.List;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCompletionHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class ModuleFlowProcessingTemplate
implements ModuleFlowProcessingPhaseTemplate {
    private final Message message;
    private final Processor messageProcessor;
    private final List<NotificationFunction> notificationFunctions;
    private final SourceCompletionHandler completionHandler;

    ModuleFlowProcessingTemplate(Message message, Processor messageProcessor, List<NotificationFunction> notificationFunctions, SourceCompletionHandler completionHandler) {
        this.message = message;
        this.messageProcessor = messageProcessor;
        this.notificationFunctions = notificationFunctions;
        this.completionHandler = completionHandler;
    }

    @Override
    public CheckedFunction<CoreEvent, Map<String, Object>> getSuccessfulExecutionResponseParametersFunction() {
        return this.completionHandler::createResponseParameters;
    }

    @Override
    public CheckedFunction<CoreEvent, Map<String, Object>> getFailedExecutionResponseParametersFunction() {
        return this.completionHandler::createFailureResponseParameters;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public List<NotificationFunction> getNotificationFunctions() {
        return this.notificationFunctions;
    }

    @Override
    public CoreEvent routeEvent(CoreEvent muleEvent) throws MuleException {
        return this.messageProcessor.process(muleEvent);
    }

    @Override
    public Publisher<CoreEvent> routeEventAsync(CoreEvent event) {
        return Mono.just(event).transform(this.messageProcessor);
    }

    @Override
    public Publisher<Void> sendResponseToClient(CoreEvent response, Map<String, Object> parameters) {
        return this.completionHandler.onCompletion(response, parameters);
    }

    @Override
    public Publisher<Void> sendFailureResponseToClient(MessagingException messagingException, Map<String, Object> parameters) {
        return this.completionHandler.onFailure(messagingException, parameters);
    }

    @Override
    public void afterPhaseExecution(Either<MessagingException, CoreEvent> either) {
        either.apply(messagingException -> this.completionHandler.onTerminate(Either.left(messagingException)), event -> this.completionHandler.onTerminate(either));
    }
}

