/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.maven.client.api.PomFileSupplierFactory;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.maven.client.internal.util.FileUtils;
import org.mule.maven.client.internal.util.MavenUtils;

public class DefaultPomFileSupplierFactory
implements PomFileSupplierFactory {
    @Override
    public Supplier<File> uncompressPomArtifactSupplier(File artifactFolder, BundleDescriptor artifactBundleDescriptor) {
        return () -> {
            String pathToPom = Paths.get("META-INF", "maven", artifactBundleDescriptor.getGroupId(), artifactBundleDescriptor.getArtifactId(), "pom.xml").toString();
            return new File(artifactFolder, pathToPom);
        };
    }

    @Override
    public Supplier<File> compressedArtifactSupplier(File artifactFile, BundleDescriptor artifactBundleDescriptor, File temporaryFolder) {
        return () -> {
            try {
                URL pomUrl = MavenUtils.getPomUrlFromJar(artifactFile);
                Optional<byte[]> pomContentOptional = FileUtils.loadFileContentFrom(pomUrl);
                byte[] pomBytes = pomContentOptional.orElseThrow(() -> new RuntimeException(String.format("No pom file found in %s", artifactFile)));
                File pomLocation = new File(temporaryFolder, String.format(".mule/plugins/%s/%s/%s/%s-%s", artifactBundleDescriptor.getGroupId(), artifactBundleDescriptor.getArtifactId(), artifactBundleDescriptor.getVersion(), artifactBundleDescriptor.getArtifactId(), artifactBundleDescriptor.getVersion()));
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(pomBytes), (File)pomLocation);
                return pomLocation;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

