/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.mule.metadata.api.TypeWriter;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.AttributeFieldType;
import org.mule.metadata.api.model.AttributeKeyType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.FunctionParameter;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.MetadataTypeConstants;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.TypeAnnotationSerializer;
import org.mule.metadata.persistence.TypeAnnotationSerializerFactory;

public class JsonMetadataTypeWriter
extends MetadataTypeVisitor
implements TypeWriter {
    private static final String UNEXPECTED_ERROR_OCCURRED_SERIALIZING = "Unexpected error occurred serializing %s";
    private static final String INDENT_TAB = "  ";
    private final ObjectTypeReferenceHandler referenceHandler;
    private boolean prettyPrint;
    private JsonWriter writer;
    private Stack<MetadataType> typeStack;
    private TypeAnnotationSerializer typeAnnotationSerializer = TypeAnnotationSerializerFactory.getInstance().getTypeAnnotationSerializer();

    public JsonMetadataTypeWriter() {
        this(new NullObjectTypeReferenceHandler());
    }

    public JsonMetadataTypeWriter(ObjectTypeReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    @Override
    public String toString(MetadataType structure) {
        try {
            StringWriter out = new StringWriter();
            this.writer = new JsonWriter((Writer)out);
            if (this.prettyPrint) {
                this.writer.setIndent(INDENT_TAB);
            }
            this.write(structure, this.writer);
            return out.toString();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "MetadataType"), e);
        }
    }

    public void write(MetadataType metadataType, JsonWriter jsonWriter) throws IOException {
        this.writer = jsonWriter;
        this.typeStack = new Stack();
        this.write(metadataType);
    }

    public JsonMetadataTypeWriter setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    private void write(MetadataType type) throws IOException {
        if (!(type instanceof SimpleType) && this.typeStack.contains(type)) {
            int indexOf = this.typeStack.indexOf(type);
            int reference = this.typeStack.size() - indexOf;
            String ref = "#";
            for (int i = 0; i < reference; ++i) {
                if (i > 0) {
                    ref = ref + "/";
                }
                ref = ref + "..";
            }
            this.writer.value(ref);
        } else {
            this.writer.beginObject();
            MetadataFormat metadataFormat = type.getMetadataFormat();
            if (this.typeStack.isEmpty() || metadataFormat != this.typeStack.peek().getMetadataFormat()) {
                this.writer.name("format");
                if (MetadataTypeConstants.commonMetadataFormats.contains(metadataFormat)) {
                    this.writer.value(metadataFormat.getId());
                } else {
                    this.writer.beginObject();
                    this.writer.name("id").value(metadataFormat.getId());
                    if (metadataFormat.getLabel().isPresent()) {
                        this.writer.name("label").value(metadataFormat.getLabel().get());
                    }
                    this.writer.name("validMimeTypes");
                    this.writer.beginArray();
                    for (String s : metadataFormat.getValidMimeTypes()) {
                        this.writer.value(s);
                    }
                    this.writer.endArray();
                    this.writer.endObject();
                }
            }
            this.typeStack.push(type);
            type.accept(this);
            this.writer.endObject();
            this.typeStack.pop();
        }
    }

    @Override
    public void visitAnyType(AnyType anyType) {
        this.writeType(anyType, "Any");
    }

    @Override
    public void visitArrayType(ArrayType arrayType) {
        this.writeType(arrayType, "Array");
        try {
            this.writer.name("item");
            this.write(arrayType.getType());
        }
        catch (IOException e) {
            throw new MetadataSerializingException("Unexpected error occurred serializing ObjectType", e);
        }
    }

    @Override
    public void visitBinaryType(BinaryType binaryType) {
        this.writeType(binaryType, "Binary");
    }

    @Override
    public void visitBoolean(BooleanType booleanType) {
        this.writeType(booleanType, "Boolean");
    }

    @Override
    public void visitDateTime(DateTimeType dateTimeType) {
        this.writeType(dateTimeType, "DateTime");
    }

    @Override
    public void visitDate(DateType dateType) {
        this.writeType(dateType, "Date");
    }

    @Override
    public void visitNull(NullType nullType) {
        this.writeType(nullType, "Null");
    }

    @Override
    public void visitNothing(NothingType nothingType) {
        this.writeType(nothingType, "Nothing");
    }

    @Override
    public void visitVoid(VoidType voidType) {
        this.writeType(voidType, "Void");
    }

    @Override
    public void visitNumber(NumberType numberType) {
        this.writeType(numberType, "Number");
    }

    @Override
    public void visitObject(ObjectType objectType) {
        if (this.referenceHandler.writeReference(objectType, this.writer).isPresent()) {
            return;
        }
        this.writeType(objectType, "Object");
        Collection<ObjectFieldType> fields = objectType.getFields();
        try {
            if (objectType.isOrdered()) {
                this.writer.name("ordered").value(true);
            }
            if (objectType.isOpen()) {
                this.writer.name("open");
                this.write(objectType.getOpenRestriction().get());
            }
            this.writer.name("fields");
            this.writer.beginArray();
            for (ObjectFieldType field : fields) {
                this.writer.beginObject();
                ObjectKeyType key = field.getKey();
                Set<TypeAnnotation> keyAnnotations = key.getAnnotations();
                HashMap<String, String> stringObjectHashMap = new HashMap<String, String>();
                if (field.isRequired()) {
                    stringObjectHashMap.put("required", "true");
                }
                if (field.isRepeated()) {
                    stringObjectHashMap.put("repeated", "true");
                }
                this.createKeyObject(keyAnnotations, field.getKey(), stringObjectHashMap);
                this.writer.name("model");
                this.write(field.getValue());
                this.writeAnnotations(field.getAnnotations());
                this.writer.endObject();
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException("Unexpected error occurred serializing ObjectType", e);
        }
    }

    @Override
    public void visitString(StringType stringType) {
        this.writeType(stringType, "String");
    }

    @Override
    public void visitTime(TimeType timeType) {
        this.writeType(timeType, "Time");
    }

    @Override
    public void visitTuple(TupleType tupleType) {
        this.writeType(tupleType, "Tuple");
        try {
            this.writer.name("of");
            this.writer.beginArray();
            List<MetadataType> types = tupleType.getTypes();
            for (MetadataType type : types) {
                this.write(type);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "Tuple"), e);
        }
    }

    @Override
    public void visitFunction(FunctionType functionType) {
        this.writeType(functionType, "Function");
        List<FunctionParameter> parameters = functionType.getParameters();
        try {
            this.writer.name("parameters");
            this.writer.beginArray();
            for (FunctionParameter parameter : parameters) {
                this.writer.beginObject();
                this.writer.name("name").value(parameter.getName());
                if (parameter.isOptional()) {
                    this.writer.name("required").value(!parameter.isOptional());
                }
                this.writer.name("type");
                this.write(parameter.getType());
                this.writer.endObject();
            }
            this.writer.endArray();
            functionType.getReturnType().ifPresent(returnType -> {
                try {
                    this.writer.name("returnType");
                    this.write((MetadataType)returnType);
                }
                catch (IOException e) {
                    throw new MetadataSerializingException("Unexpected error occurred serializing the returnType field for FunctionType", e);
                }
            });
        }
        catch (IOException e) {
            throw new MetadataSerializingException("Unexpected error occurred serializing FunctionType", e);
        }
    }

    @Override
    public void visitUnion(UnionType unionType) {
        this.writeType(unionType, "Union");
        try {
            this.writer.name("of");
            this.writer.beginArray();
            List<MetadataType> types = unionType.getTypes();
            for (MetadataType type : types) {
                this.write(type);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "Union"), e);
        }
    }

    @Override
    public void visitIntersection(IntersectionType intersectionType) {
        this.writeType(intersectionType, "Intersection");
        try {
            this.writer.name("of");
            this.writer.beginArray();
            List<MetadataType> types = intersectionType.getTypes();
            for (MetadataType type : types) {
                this.write(type);
            }
            this.writer.endArray();
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, "Intersection"), e);
        }
    }

    private void writeType(MetadataType metadataType, String type) {
        try {
            this.writer.name("type").value(type);
            this.writeAnnotations(metadataType.getAnnotations());
        }
        catch (IOException e) {
            throw new MetadataSerializingException(String.format(UNEXPECTED_ERROR_OCCURRED_SERIALIZING, type), e);
        }
    }

    private void writeAnnotations(Collection<TypeAnnotation> annotations) throws IOException {
        List publicAnnotations = annotations.stream().filter(TypeAnnotation::isPublic).collect(Collectors.toList());
        if (!publicAnnotations.isEmpty()) {
            this.writer.name("annotations");
            this.writer.beginObject();
            for (TypeAnnotation annotation : publicAnnotations) {
                this.writer.name(this.getAnnotationJsonName(annotation));
                this.typeAnnotationSerializer.serialize(this.writer, annotation);
            }
            this.writer.endObject();
        }
    }

    private String getAnnotationJsonName(TypeAnnotation annotation) {
        if (this.typeAnnotationSerializer.getNameClassMapping().containsKey(annotation.getName())) {
            return annotation.getName();
        }
        return annotation.getClass().getName();
    }

    private void createKeyObject(Collection<TypeAnnotation> keyAnnotations, ObjectKeyType key, HashMap<String, String> additionalProperties) throws IOException {
        String keyString;
        this.writer.name("key");
        this.writer.beginObject();
        this.writer.name("name");
        if (key.isName()) {
            keyString = key.getName().toString();
        } else {
            keyString = key.getPattern().toString();
            RegexPatternAnnotation patternAnnotation = new RegexPatternAnnotation(keyString);
            if (!keyAnnotations.contains(patternAnnotation)) {
                keyAnnotations.add(patternAnnotation);
            }
        }
        this.writer.value(keyString);
        this.writeAnnotations(keyAnnotations);
        this.createAttributes(key);
        for (Map.Entry<String, String> property : additionalProperties.entrySet()) {
            this.writer.name(property.getKey()).value(property.getValue());
        }
        this.writer.endObject();
    }

    private void createAttributes(ObjectKeyType key) throws IOException {
        Collection<AttributeFieldType> attributes = key.getAttributes();
        if (!attributes.isEmpty()) {
            this.writer.name("attributes");
            this.writer.beginArray();
            for (AttributeFieldType attribute : attributes) {
                this.createAttribute(attribute);
            }
            this.writer.endArray();
        }
    }

    private Map<String, String> getAttributeAdditionalProperties(AttributeFieldType attribute) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (attribute.isRequired()) {
            result.put("required", "true");
        }
        return result;
    }

    private void createAttribute(AttributeFieldType attribute) throws IOException {
        this.writer.beginObject();
        AttributeKeyType attributeKey = attribute.getKey();
        this.createAttributeKeyObject(attributeKey, this.getAttributeAdditionalProperties(attribute));
        this.writer.name("model");
        this.write(attribute.getValue());
        this.writeAnnotations(attribute.getAnnotations());
        this.writer.endObject();
    }

    private void createAttributeKeyObject(AttributeKeyType key, Map<String, String> additionalProperties) throws IOException {
        String keyString;
        this.writer.name("key");
        this.writer.beginObject();
        this.writer.name("name");
        ArrayList<TypeAnnotation> keyAnnotations = new ArrayList<TypeAnnotation>();
        if (key.isName()) {
            keyString = key.getName().toString();
        } else {
            keyString = key.getPattern().toString();
            RegexPatternAnnotation patternAnnotation = new RegexPatternAnnotation(keyString);
            if (!keyAnnotations.contains(patternAnnotation)) {
                keyAnnotations.add(patternAnnotation);
            }
        }
        this.writer.value(keyString);
        this.writeAnnotations(keyAnnotations);
        for (Map.Entry<String, String> property : additionalProperties.entrySet()) {
            this.writer.name(property.getKey()).value(property.getValue());
        }
        this.writer.endObject();
    }
}

