/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model.metadata;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheId;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGenerator;
import org.mule.runtime.core.internal.metadata.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslElementBasedMetadataCacheIdGenerator
implements MetadataCacheIdGenerator<DslElementModel<?>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DslElementBasedMetadataCacheIdGenerator.class);
    private final MetadataCacheIdGeneratorFactory.ComponentLocator<DslElementModel<?>> locator;

    public DslElementBasedMetadataCacheIdGenerator(MetadataCacheIdGeneratorFactory.ComponentLocator<DslElementModel<?>> locator) {
        this.locator = locator;
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentMetadata(DslElementModel<?> elementModel) {
        return this.doResolve(elementModel, true);
    }

    @Override
    public Optional<MetadataCacheId> getIdForMetadataKeys(DslElementModel<?> elementModel) {
        return this.doResolve(elementModel, false);
    }

    @Override
    public Optional<MetadataCacheId> getIdForGlobalMetadata(DslElementModel<?> elementModel) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        if (elementModel.getModel() instanceof ConfigurationModel) {
            this.resolveDslTagId(elementModel).ifPresent(keyParts::add);
            this.resolveGlobalElement(elementModel).ifPresent(keyParts::add);
            return Optional.of(new MetadataCacheId(keyParts, this.getSourceElementName(elementModel)));
        }
        Optional<MetadataCacheId> configId = this.resolveConfigId(elementModel);
        if (configId.isPresent()) {
            keyParts.add(configId.get());
            this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
            return Optional.of(new MetadataCacheId(keyParts, this.getSourceElementName(elementModel)));
        }
        return this.resolveDslTagId(elementModel);
    }

    private Optional<MetadataCacheId> resolveCategoryId(DslElementModel<?> elementModel) {
        if (!(elementModel.getModel() instanceof ComponentModel)) {
            return Optional.empty();
        }
        return ((ComponentModel)elementModel.getModel()).getModelProperty(MetadataKeyIdModelProperty.class).map(mp -> mp.getCategoryName().orElse(null)).map(name -> new MetadataCacheId(name.hashCode(), "category:" + name));
    }

    private Optional<MetadataCacheId> doResolve(DslElementModel<?> elementModel, boolean includeAllKeys) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        this.resolveConfigId(elementModel).ifPresent(keyParts::add);
        this.resolveCategoryId(elementModel).ifPresent(keyParts::add);
        this.resolveDslTagId(elementModel).ifPresent(keyParts::add);
        Object model = elementModel.getModel();
        if (model instanceof ComponentModel) {
            this.resolveMetadataKeyParts(elementModel, (ComponentModel)model, includeAllKeys).ifPresent(keyParts::add);
        } else {
            this.resolveGlobalElement(elementModel).ifPresent(keyParts::add);
        }
        return Optional.of(new MetadataCacheId(keyParts, this.getSourceElementName(elementModel)));
    }

    private Optional<MetadataCacheId> resolveDslTagId(DslElementModel<?> elementModel) {
        return elementModel.getIdentifier().map(id -> new MetadataCacheId(id.hashCode(), id.toString()));
    }

    private String getSourceElementName(DslElementModel<?> elementModel) {
        return elementModel.getDsl().getPrefix() + ":" + this.getModelName(elementModel.getModel()).orElse(elementModel.getDsl().getElementName()) + elementModel.getConfiguration().map(c -> c.getParameters().get("name")).filter(Objects::nonNull).map(n -> "[" + n + "]").orElse("");
    }

    private Optional<MetadataCacheId> resolveConfigId(DslElementModel<?> elementModel) {
        String configRef;
        Optional<ComponentConfiguration> configuration = elementModel.getConfiguration();
        if (configuration.isPresent() && !StringUtils.isBlank(configRef = configuration.get().getParameters().get("config-ref"))) {
            return this.getHashedGlobal(configRef);
        }
        return Optional.empty();
    }

    private Optional<MetadataCacheId> resolveGlobalElement(DslElementModel<?> elementModel) {
        ArrayList<MetadataCacheId> parts = new ArrayList<MetadataCacheId>();
        elementModel.getContainedElements().stream().filter(containedElement -> containedElement.getModel() != null).forEach(containedElement -> {
            if (containedElement.getValue().isPresent()) {
                this.resolveKeyFromSimpleValue((DslElementModel<?>)containedElement).ifPresent(parts::add);
            } else {
                this.getIdForComponentMetadata((DslElementModel<?>)containedElement).ifPresent(parts::add);
            }
        });
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MetadataCacheId(parts, (String)this.getModelName(elementModel.getModel()).orElse(null)));
    }

    private Optional<MetadataCacheId> resolveMetadataKeyParts(DslElementModel<?> elementModel, ComponentModel componentModel, boolean includeAllKeys) {
        if (!includeAllKeys) {
            boolean isMultilevel = componentModel.getModelProperty(MetadataKeyIdModelProperty.class).map(MetadataKeyIdModelProperty::getType).map(t -> t instanceof ObjectType).orElse(false);
            boolean isPartialFetching = componentModel.getModelProperty(MetadataResolverFactoryModelProperty.class).map(mp -> mp.getMetadataResolverFactory().getKeyResolver()).map(resolver -> resolver instanceof PartialTypeKeysResolver).orElse(false);
            if (!isMultilevel || !isPartialFetching) {
                return Optional.empty();
            }
        }
        ArrayList<MetadataCacheId> parts = new ArrayList<MetadataCacheId>();
        componentModel.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).map(metadataKeyPart -> elementModel.findElement(metadataKeyPart.getName())).filter(Optional::isPresent).map(Optional::get).filter(partElement -> partElement.getValue().isPresent()).forEach(partElement -> this.resolveKeyFromSimpleValue((DslElementModel<?>)partElement).ifPresent(parts::add));
        return parts.isEmpty() ? Optional.empty() : Optional.of(new MetadataCacheId(parts, "metadataKey"));
    }

    private Optional<MetadataCacheId> resolveKeyFromSimpleValue(DslElementModel<?> element) {
        if (element == null || !element.getValue().isPresent()) {
            return Optional.empty();
        }
        final String value = element.getValue().get();
        String sourceElementName = this.getModelName(element.getModel()).map(modelName -> StringUtils.isBlank(element.getDsl().getPrefix()) ? modelName : element.getDsl().getPrefix() + ":" + modelName).orElseGet(() -> element.getIdentifier().map(Object::toString).orElse(null));
        MetadataCacheId valuePart = new MetadataCacheId(value.hashCode(), sourceElementName);
        if (value.contains("#[")) {
            return Optional.of(valuePart);
        }
        final Reference reference = new Reference();
        if (element.getModel() instanceof ParameterModel) {
            final ParameterModel model = (ParameterModel)element.getModel();
            model.getType().accept(new MetadataTypeVisitor(){

                @Override
                public void visitString(StringType stringType) {
                    if (!model.getAllowedStereotypes().isEmpty()) {
                        DslElementBasedMetadataCacheIdGenerator.this.getHashedGlobal(value).ifPresent(reference::set);
                    }
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    if (model.getDslConfiguration().allowsReferences()) {
                        DslElementBasedMetadataCacheIdGenerator.this.getHashedGlobal(value).ifPresent(reference::set);
                    }
                }

                @Override
                public void visitObject(ObjectType objectType) {
                    if (model.getDslConfiguration().allowsReferences()) {
                        DslElementBasedMetadataCacheIdGenerator.this.getHashedGlobal(value).ifPresent(reference::set);
                    }
                }
            });
        } else if (element.getModel() instanceof MetadataType) {
            ((MetadataType)element.getModel()).accept(new MetadataTypeVisitor(){

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    DslElementBasedMetadataCacheIdGenerator.this.getHashedGlobal(value).ifPresent(reference::set);
                }

                @Override
                public void visitObject(ObjectType objectType) {
                    boolean canBeGlobal = objectType.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
                    if (canBeGlobal) {
                        DslElementBasedMetadataCacheIdGenerator.this.getHashedGlobal(value).ifPresent(reference::set);
                    }
                }
            });
        } else {
            LOGGER.warn(String.format("Unknown model type '%s' found for element '%s'", String.valueOf(element.getModel()), element.getIdentifier().map(Object::toString).orElse(sourceElementName)));
        }
        return Optional.of(reference.get() == null ? valuePart : (MetadataCacheId)reference.get());
    }

    private Optional<MetadataCacheId> getHashedGlobal(String name) {
        if (!StringUtils.isBlank(name)) {
            return this.locator.get(Location.builder().globalName(name).build()).map(global -> this.getIdForComponentMetadata((DslElementModel<?>)global).orElse(null));
        }
        return Optional.empty();
    }

    private Optional<String> getModelName(Object model) {
        if (model instanceof NamedObject) {
            return Optional.of(((NamedObject)model).getName());
        }
        if (model instanceof ObjectType) {
            return ExtensionMetadataTypeUtils.getId((MetadataType)model);
        }
        return Optional.empty();
    }
}

