/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.rx;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.func.CheckedBiConsumer;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.core.api.util.func.CheckedBiPredicate;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.func.CheckedPredicate;

public class Exceptions {
    private static final String REACTIVE_EXCEPTION_CLASS_NAME = "reactor.core.Exceptions$ReactiveException";

    public static <T> Consumer<T> checkedConsumer(CheckedConsumer<T> checkedConsumer) {
        return t -> checkedConsumer.accept(t);
    }

    public static <T, U> BiConsumer<T, U> checkedConsumer(CheckedBiConsumer<T, U> checkedBiConsumer) {
        return (t, u) -> checkedBiConsumer.accept(t, u);
    }

    public static <T, R> Function<T, R> checkedFunction(CheckedFunction<T, R> checkedFunction) {
        return t -> checkedFunction.apply(t);
    }

    public static <T, U, R> BiFunction<T, U, R> checkedFunction(CheckedBiFunction<T, U, R> checkedBiFunction) {
        return (t, u) -> checkedBiFunction.apply(t, u);
    }

    public static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> checkedPredicate) {
        return t -> checkedPredicate.test(t);
    }

    public static <T, U> BiPredicate<T, U> checkedPredicate(CheckedBiPredicate<T, U> checkedBiPredicate) {
        return (t, u) -> checkedBiPredicate.test(t, u);
    }

    public static MuleException rxExceptionToMuleException(Throwable throwable) throws MuleException {
        if ((throwable = Exceptions.unwrap(throwable)) instanceof MuleException) {
            return (MuleException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new DefaultMuleException(throwable);
    }

    public static Throwable unwrap(Throwable throwable) {
        while (throwable.getClass().getName().equals(REACTIVE_EXCEPTION_CLASS_NAME)) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static RuntimeException propagateWrappingFatal(Throwable t) {
        return reactor.core.Exceptions.propagate(Exceptions.wrapFatal(t));
    }

    public static Throwable wrapFatal(Throwable t) {
        if (t instanceof LinkageError) {
            return new MuleFatalException(t);
        }
        if (t instanceof VirtualMachineError) {
            return new MuleFatalException(t);
        }
        if (reactor.core.Exceptions.isBubbling(t)) {
            return new MuleRuntimeException(Exceptions.unwrap(t));
        }
        return t;
    }

    private Exceptions() {
    }
}

