/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;

public class NamedThreadFactory
implements ThreadFactory {
    private AccessControlContext acc = AccessController.getContext();
    private final String name;
    private final AtomicLong counter;
    private final ClassLoader contextClassLoader;
    private final ThreadGroup threadGroup;

    public NamedThreadFactory(String name) {
        this(name, null, null);
    }

    public NamedThreadFactory(String name, ClassLoader contextClassLoader) {
        this(name, contextClassLoader, null);
    }

    public NamedThreadFactory(String name, ClassLoader contextClassLoader, ThreadGroup threadGroup) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("NamedThreadFactory must have a proper name.");
        }
        this.name = name;
        this.contextClassLoader = contextClassLoader;
        this.threadGroup = threadGroup;
        this.counter = new AtomicLong(1L);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Supplier<Thread> tf = () -> {
            Thread t = this.threadGroup != null ? new Thread(this.threadGroup, runnable) : new Thread(runnable);
            this.configureThread(t);
            return t;
        };
        if (this.contextClassLoader != null) {
            return ClassUtils.withContextClassLoader(this.getClass().getClassLoader(), () -> AccessController.doPrivileged(() -> NamedThreadFactory.lambda$null$1((Supplier)tf), this.acc));
        }
        return tf.get();
    }

    protected void configureThread(Thread t) {
        if (this.contextClassLoader != null) {
            t.setContextClassLoader(this.contextClassLoader);
        }
        this.doConfigureThread(t);
    }

    protected void doConfigureThread(Thread t) {
        t.setName(String.format("%s.%02d", this.name, this.counter.getAndIncrement()));
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public AtomicLong getCounter() {
        return this.counter;
    }

    public String getName() {
        return this.name;
    }

    private static /* synthetic */ Thread lambda$null$1(Supplier tf) {
        return (Thread)tf.get();
    }
}

