/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.policy.api.OperationPolicyPointcutParametersFactory;
import org.mule.runtime.policy.api.PolicyPointcutParameters;
import org.mule.runtime.policy.api.SourcePolicyPointcutParametersFactory;

public class PolicyPointcutParametersManager {
    private final Collection<SourcePolicyPointcutParametersFactory> sourcePointcutFactories;
    private final Collection<OperationPolicyPointcutParametersFactory> operationPointcutFactories;
    private final Map<String, PolicyPointcutParameters> sourceParametersMap;

    public PolicyPointcutParametersManager(Collection<SourcePolicyPointcutParametersFactory> sourcePointcutFactories, Collection<OperationPolicyPointcutParametersFactory> operationPointcutFactories) {
        this.sourcePointcutFactories = sourcePointcutFactories;
        this.operationPointcutFactories = operationPointcutFactories;
        this.sourceParametersMap = new ConcurrentHashMap<String, PolicyPointcutParameters>();
    }

    public PolicyPointcutParameters createSourcePointcutParameters(Component source, CoreEvent event) {
        ComponentIdentifier sourceIdentifier = source.getLocation().getComponentIdentifier().getIdentifier();
        PolicyPointcutParameters sourcePointcutParameters = this.createPointcutParameters(source, SourcePolicyPointcutParametersFactory.class, this.sourcePointcutFactories, factory -> factory.supportsSourceIdentifier(sourceIdentifier), factory -> factory.createPolicyPointcutParameters(source, event.getMessage().getAttributes())).orElse(new PolicyPointcutParameters(source));
        String correlationId = event.getContext().getCorrelationId();
        this.sourceParametersMap.put(correlationId, sourcePointcutParameters);
        ((BaseEventContext)event.getContext()).getRootContext().onTerminated((e, t) -> this.sourceParametersMap.remove(correlationId));
        return sourcePointcutParameters;
    }

    public PolicyPointcutParameters createOperationPointcutParameters(Component operation, CoreEvent event, Map<String, Object> operationParameters) {
        ComponentIdentifier operationIdentifier = operation.getLocation().getComponentIdentifier().getIdentifier();
        PolicyPointcutParameters sourceParameters = this.sourceParametersMap.get(event.getContext().getCorrelationId());
        Function<OperationPolicyPointcutParametersFactory, PolicyPointcutParameters> creationFunction = factory -> {
            try {
                return factory.createPolicyPointcutParameters(operation, operationParameters, sourceParameters);
            }
            catch (AbstractMethodError error) {
                return factory.createPolicyPointcutParameters(operation, operationParameters);
            }
        };
        return this.createPointcutParameters(operation, OperationPolicyPointcutParametersFactory.class, this.operationPointcutFactories, factory -> factory.supportsOperationIdentifier(operationIdentifier), creationFunction).orElse(new PolicyPointcutParameters(operation, sourceParameters));
    }

    private <T> Optional<PolicyPointcutParameters> createPointcutParameters(Component component, Class<T> factoryType, Collection<T> factories, Predicate<T> factoryFilter, Function<T, PolicyPointcutParameters> policyPointcutParametersCreationFunction) {
        Object found = null;
        for (T factory : factories) {
            if (!factoryFilter.test(factory)) continue;
            if (found != null) {
                this.throwMoreThanOneFactoryFoundException(component.getLocation().getComponentIdentifier().getIdentifier(), factoryType);
            }
            found = factory;
        }
        return found != null ? Optional.of(policyPointcutParametersCreationFunction.apply(found)) : Optional.empty();
    }

    private void throwMoreThanOneFactoryFoundException(ComponentIdentifier sourceIdentifier, Class factoryClass) {
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("More than one %s for component %s was found. There should be only one.", factoryClass.getName(), sourceIdentifier)));
    }
}

