/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader.exception;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;

@NoInstantiate
public final class CompositeClassNotFoundException
extends ClassNotFoundException {
    private static final long serialVersionUID = -6941980241656380059L;
    private final String className;
    private final LookupStrategy lookupStrategy;
    private final List<ClassNotFoundException> exceptions;

    public CompositeClassNotFoundException(String className, LookupStrategy lookupStrategy, List<ClassNotFoundException> exceptions) {
        super(String.format("Cannot load class '%s': %s", className, exceptions.stream().map(e -> System.lineSeparator() + "\t" + e.getMessage()).collect(Collectors.toList())), exceptions.get(0));
        this.className = className;
        this.lookupStrategy = lookupStrategy;
        this.exceptions = ImmutableList.copyOf(exceptions);
    }

    public String getClassName() {
        return this.className;
    }

    public LookupStrategy getLookupStrategy() {
        return this.lookupStrategy;
    }

    public List<ClassNotFoundException> getExceptions() {
        return this.exceptions;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        if (MuleException.isVerboseExceptions()) {
            return super.fillInStackTrace();
        }
        return this;
    }
}

