/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher.stereotypes;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithConstructsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithStereotypesDeclaration;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.DefaultExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.ClassStereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.MethodStereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.enricher.stereotypes.StereotypeResolver;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingMethodModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.MethodWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;

public class StereotypesDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ClassUtils.withContextClassLoader(extensionLoadingContext.getExtensionClassLoader(), () -> new EnricherDelegate().apply(extensionLoadingContext));
    }

    private static class EnricherDelegate {
        private final Map<StereotypeDefinition, StereotypeModel> stereotypes = new HashMap<StereotypeDefinition, StereotypeModel>();

        private EnricherDelegate() {
        }

        public void apply(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclarer extensionDeclarer = extensionLoadingContext.getExtensionDeclarer();
            final ClassTypeLoader typeLoader = new DefaultExtensionsTypeLoaderFactory().createTypeLoader(extensionLoadingContext.getExtensionClassLoader());
            ExtensionDeclaration declaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            Optional<ImplementingTypeModelProperty> implementingType = declaration.getModelProperty(ImplementingTypeModelProperty.class);
            final String namespace = this.getStereotypePrefix(extensionDeclarer);
            if (implementingType.isPresent()) {
                new IdempotentDeclarationWalker(){

                    @Override
                    protected void onConfiguration(ConfigurationDeclaration declaration) {
                        StereotypeModel defaultConfigStereotype = StereotypeModelBuilder.newStereotype(declaration.getName(), namespace).withParent(MuleStereotypes.CONFIG).build();
                        FunctionalUtils.ifPresent(declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(ExtensionTypeDescriptorModelProperty::getType), type -> new ClassStereotypeResolver((Type)type, (WithStereotypesDeclaration)declaration, namespace, defaultConfigStereotype, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype(), () -> declaration.withStereotype(defaultConfigStereotype));
                    }

                    @Override
                    protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                        StereotypeModel defaultConnectionStereotype = StereotypeModelBuilder.newStereotype(declaration.getName(), namespace).withParent(MuleStereotypes.CONNECTION).build();
                        FunctionalUtils.ifPresent(declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(ExtensionTypeDescriptorModelProperty::getType), type -> new ClassStereotypeResolver((Type)type, (WithStereotypesDeclaration)declaration, namespace, defaultConnectionStereotype, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype(), () -> declaration.withStereotype(defaultConnectionStereotype));
                    }

                    @Override
                    protected void onConstruct(WithConstructsDeclaration owner, ConstructDeclaration declaration) {
                        declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).map(method -> new MethodWrapper((Method)method, typeLoader)).ifPresent(methodElement -> new MethodStereotypeResolver((MethodWrapper)methodElement, declaration, namespace, MuleStereotypes.PROCESSOR, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }

                    @Override
                    public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                        declaration.getModelProperty(ImplementingMethodModelProperty.class).map(ImplementingMethodModelProperty::getMethod).map(method -> new MethodWrapper((Method)method, typeLoader)).ifPresent(methodElement -> new MethodStereotypeResolver((MethodWrapper)methodElement, declaration, namespace, MuleStereotypes.PROCESSOR, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }

                    @Override
                    protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                        declaration.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).ifPresent(declaringType -> new ClassStereotypeResolver(new TypeWrapper((Class<?>)declaringType, typeLoader), (WithStereotypesDeclaration)declaration, namespace, MuleStereotypes.SOURCE, (Map<StereotypeDefinition, StereotypeModel>)stereotypes).resolveStereotype());
                    }
                }.walk(declaration);
            }
            this.resolveStereotypes(declaration, namespace);
        }

        private void resolveStereotypes(ExtensionDeclaration declaration, String namespace) {
            Function<Class, StereotypeModel> resolver = def -> StereotypeResolver.createCustomStereotype(def, namespace, this.stereotypes);
            declaration.getTypes().forEach(type -> this.resolveStereotype((ObjectType)type, (Function<Class<? extends StereotypeDefinition>, StereotypeModel>)resolver));
        }

        private void resolveStereotype(ObjectType type, final Function<Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
            type.accept(new MetadataTypeVisitor(){
                private List<MetadataType> registeredTypes = new LinkedList<MetadataType>();

                @Override
                public void visitObject(ObjectType objectType) {
                    if (!this.registeredTypes.contains(objectType)) {
                        this.registeredTypes.add(objectType);
                        objectType.getAnnotation(StereotypeTypeAnnotation.class).ifPresent(a -> a.resolveStereotypes(resolver));
                        objectType.getFields().forEach(f -> f.getValue().accept(this));
                    }
                }

                @Override
                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept(this);
                }

                @Override
                public void visitUnion(UnionType unionType) {
                    unionType.getTypes().forEach(t -> t.accept(this));
                }

                @Override
                public void visitIntersection(IntersectionType intersectionType) {
                    intersectionType.getTypes().forEach(t -> t.accept(this));
                }
            });
        }

        private String getStereotypePrefix(ExtensionDeclarer extensionDeclarer) {
            return ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).getXmlDslModel().getPrefix().toUpperCase();
        }
    }
}

