/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.api.loader.java.type.SourceElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.annotations.CustomDefinedStaticTypeAnnotation;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.ModelValidationUtils;

public class MediaTypeModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        if (!ModelValidationUtils.isCompiletime(extensionModel)) {
            return;
        }
        new IdempotentExtensionWalker(){

            @Override
            protected void onOperation(OperationModel model) {
                this.validateMediaType(model, model.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(mp -> mp.getOperationReturnType()));
            }

            @Override
            protected void onSource(SourceModel model) {
                Optional<Type> outputType = model.getModelProperty(ExtensionTypeDescriptorModelProperty.class).filter(mp -> mp.getType() instanceof SourceElement).map(mp -> (SourceElement)mp.getType()).map(SourceElement::getReturnType);
                this.validateMediaType(model, outputType);
            }

            private void validateMediaType(ConnectableComponentModel model, Optional<Type> outputType) {
                MetadataType outputMetadataType = outputType.map(type -> type.asMetadataType()).orElse(model.getOutput().getType());
                if (this.mediaTypeAnnotationIsMissing(model, outputMetadataType)) {
                    String componentType = NameUtils.getComponentModelTypeName(model);
                    String message = String.format("%s '%s' has a %s type output but doesn't specify a default mime type. Please annotate it with @%s", StringUtils.capitalize((String)componentType), model.getName(), outputMetadataType instanceof StringType ? "String" : "InputStream", MediaType.class.getSimpleName());
                    problemsReporter.addError(new Problem(model, message));
                } else if (this.staticResolverClashesWithMediaTypeAnnotationValue(model, outputMetadataType)) {
                    String componentType = NameUtils.getComponentModelTypeName(model);
                    String message = String.format("%s '%s' is declaring both a custom output Type using a Static MetadataResolver, and a custom media type through the @%s annotation. Enforce 'MediaType' you want using the '%s' given to your Type Builder. You can still use the @%s annotation to set `strict=false` and keep letting the user configure the outputMimeType parameter.", StringUtils.capitalize((String)componentType), model.getName(), org.mule.runtime.api.metadata.MediaType.class.getSimpleName(), MetadataFormat.class.getName(), org.mule.runtime.api.metadata.MediaType.class.getSimpleName());
                    problemsReporter.addError(new Problem(model, message));
                } else if (this.mediaTypeAnnotationIsMissingValue(model, outputMetadataType)) {
                    String componentType = NameUtils.getComponentModelTypeName(model);
                    String message = String.format("%s '%s' has a %s type output but doesn't specify a default mime type. Please give a value to the @%s annotation", StringUtils.capitalize((String)componentType), model.getName(), outputMetadataType instanceof StringType ? "String" : "InputStream", MediaType.class.getSimpleName());
                    problemsReporter.addError(new Problem(model, message));
                }
            }

            private boolean mediaTypeAnnotationIsMissingValue(ConnectableComponentModel model, MetadataType outputMetadataType) {
                Optional<MediaTypeModelProperty> mediaTypeModelProperty = model.getModelProperty(MediaTypeModelProperty.class);
                return this.outputTypeNeedsMediaTypeAnnotation(outputMetadataType) && this.hasMediaTypeModelProperty(model) && this.mediaTypeModelPropertyHasDefaultValue(mediaTypeModelProperty.get()) && !this.hasStaticMetadataDefined(model, null);
            }

            private boolean staticResolverClashesWithMediaTypeAnnotationValue(ConnectableComponentModel model, MetadataType outputMetadataType) {
                MediaTypeModelProperty mediaTypeModelProperty = model.getModelProperty(MediaTypeModelProperty.class).orElse(null);
                return this.outputTypeNeedsMediaTypeAnnotation(outputMetadataType) && this.hasMediaTypeModelProperty(model) && !this.mediaTypeModelPropertyHasDefaultValue(mediaTypeModelProperty) && this.hasStaticMetadataDefined(model, mediaTypeModelProperty.getMediaType().get());
            }

            private boolean mediaTypeAnnotationIsMissing(ConnectableComponentModel model, MetadataType outputMetadataType) {
                return this.outputTypeNeedsMediaTypeAnnotation(outputMetadataType) && !this.hasMediaTypeModelProperty(model) && !this.hasStaticMetadataDefined(model, null);
            }

            private boolean hasStaticMetadataDefined(ConnectableComponentModel model, org.mule.runtime.api.metadata.MediaType mediaTypeFromModelProperty) {
                if (mediaTypeFromModelProperty == null) {
                    return this.hasCustomStaticMetadataDefined(model.getOutput()) || !this.hasJavaAsMetadataFormat(model.getOutput());
                }
                return this.hasCustomStaticMetadataDefined(model.getOutput()) || this.modelMediaTypeDiffersFromMediaType(model.getOutput(), mediaTypeFromModelProperty);
            }

            private boolean hasJavaAsMetadataFormat(OutputModel model) {
                return model.getType().getMetadataFormat().getId().equals(MetadataFormat.JAVA.getId());
            }

            private boolean hasMediaTypeModelProperty(ConnectableComponentModel model) {
                return model.getModelProperty(MediaTypeModelProperty.class).isPresent();
            }

            private boolean hasCustomStaticMetadataDefined(OutputModel model) {
                return model.getType().getAnnotation(CustomDefinedStaticTypeAnnotation.class).isPresent();
            }

            private boolean modelMediaTypeDiffersFromMediaType(OutputModel model, org.mule.runtime.api.metadata.MediaType mediaType) {
                return !model.getType().getMetadataFormat().equals(ExtensionMetadataTypeUtils.toMetadataFormat(mediaType));
            }

            private boolean mediaTypeModelPropertyHasDefaultValue(MediaTypeModelProperty mediaTypeModelProperty) {
                return !mediaTypeModelProperty.getMediaType().isPresent();
            }

            private boolean outputTypeNeedsMediaTypeAnnotation(MetadataType metadataType) {
                return metadataType instanceof StringType && !metadataType.getAnnotation(EnumAnnotation.class).isPresent() || metadataType instanceof BinaryType;
            }
        }.walk(extensionModel);
    }
}

