/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.util.Optional;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;

public class MediaTypeUtils {
    public static MediaType getDefaultMediaType(ComponentModel componentModel) {
        Optional<MediaTypeModelProperty> mediaTypeModelProperty = componentModel.getModelProperty(MediaTypeModelProperty.class);
        if (mediaTypeModelProperty.isPresent() && mediaTypeModelProperty.get().getMediaType().isPresent()) {
            return mediaTypeModelProperty.get().getMediaType().get();
        }
        if (componentModel instanceof HasOutputModel) {
            MetadataType output = ((HasOutputModel)((Object)componentModel)).getOutput().getType();
            return MetadataFormat.JAVA.equals(output.getMetadataFormat()) && output instanceof ObjectType ? MediaType.APPLICATION_JAVA : MediaTypeUtils.getMediaTypeFromMetadataType(output);
        }
        return MediaType.ANY;
    }

    private static MediaType getMediaTypeFromMetadataType(MetadataType output) {
        if (output.getMetadataFormat() != null && output.getMetadataFormat().getValidMimeTypes().size() == 1) {
            return MediaType.parse(output.getMetadataFormat().getValidMimeTypes().iterator().next());
        }
        return MediaType.ANY;
    }
}

