/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.mule.apache.xerces.dom.DOMInputImpl;
import org.mule.apache.xerces.xs.XSLoader;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelFactoryFromExampleSupport {
    static List<String> fixForMultipleSchemas(XSLoader schemaLoader, List<String> schemas) throws TransformerException {
        ArrayList targetNamespaces = new ArrayList();
        schemas.forEach(schema -> {
            try {
                targetNamespaces.add(ModelFactoryFromExampleSupport.findTargetNamespace(schema).orElse(""));
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new RuntimeException("Failed resolving example metadata type", e);
            }
        });
        final HashMap<String, String> schemasByNamespaceUri = new HashMap<String, String>();
        ArrayList<String> tmpSchemas = new ArrayList<String>();
        for (int i = 0; i < schemas.size(); ++i) {
            String currentTargetNamespace = (String)targetNamespaces.get(i);
            String schema2 = schemas.get(i);
            String fixedSchema = ModelFactoryFromExampleSupport.fixSchemaAddingImports(schema2, targetNamespaces.stream().filter(targetNamespace -> !targetNamespace.equals(currentTargetNamespace)).collect(Collectors.toList()));
            tmpSchemas.add(fixedSchema);
            schemasByNamespaceUri.put(currentTargetNamespace, fixedSchema);
        }
        schemaLoader.getConfig().setParameter("resource-resolver", new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                return Optional.ofNullable(schemasByNamespaceUri.get(Optional.ofNullable(namespaceURI).orElse(""))).map(schema -> new DOMInputImpl(publicId, systemId, baseURI, new StringReader((String)schema), "UTF-8")).orElse(null);
            }
        });
        return tmpSchemas;
    }

    private static String fixSchemaAddingImports(String schema, List<String> targetNamespaces) throws TransformerException {
        ByteArrayOutputStream resultOutputStream = new ByteArrayOutputStream();
        Templates template = ModelFactoryFromExampleSupport.buildSchemaAddingTransform(targetNamespaces);
        Transformer transformer = template.newTransformer();
        StreamSource streamSource = new StreamSource(new StringReader(schema));
        StreamResult streamResult = new StreamResult(resultOutputStream);
        transformer.transform(streamSource, streamResult);
        return resultOutputStream.toString();
    }

    private static Templates buildSchemaAddingTransform(List<String> targetNamespaces) throws TransformerConfigurationException {
        StringBuilder stringBuilder = new StringBuilder();
        targetNamespaces.forEach(targetNamespace -> stringBuilder.append(targetNamespace.isEmpty() ? "<xs:import xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"/>" : String.format("<xs:import namespace=\"%s\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"/>", targetNamespace)));
        String importsSection = stringBuilder.toString();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        return transformerFactory.newTemplates(new StreamSource(new StringReader(String.format("<?xml version = \"1.0\" encoding = \"UTF-8\"?>\n<xsl:stylesheet version = \"1.0\" xmlns:xsl = \"http://www.w3.org/1999/XSL/Transform\">\n  <xsl:template match=\"node()|@*\">\n    <xsl:copy>\n      <xsl:apply-templates select=\"node()|@*\"/>\n    </xsl:copy>\n  </xsl:template>\n\n  <xsl:template match=\"/xs:schema\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n    <xsl:copy>\n      <xsl:apply-templates select=\"@*\"/>\n      %s\n      <xsl:apply-templates select=\"node()\"/>\n    </xsl:copy>\n  </xsl:template>\n\n</xsl:stylesheet>", importsSection))));
    }

    private static Optional<String> findTargetNamespace(String schema) throws ParserConfigurationException, XPathExpressionException, IOException, SAXException {
        InputSource source = new InputSource(new StringReader(schema));
        String path = "string(/schema/@targetNamespace)";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(source);
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression xPathExpression = xpath.compile(path);
        return Optional.ofNullable((String)xPathExpression.evaluate(doc, XPathConstants.STRING));
    }
}

