/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerMessageProcessor
extends AbstractComponent
implements Processor,
Initialisable,
MuleContextAware {
    protected transient Logger logger;
    protected String message;
    protected String category;
    protected String level = "INFO";
    protected MuleContext muleContext;
    ExtendedExpressionManager expressionManager;

    @Override
    public void initialise() throws InitialisationException {
        this.initLogger();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void initLogger() {
        this.logger = this.category != null ? LoggerFactory.getLogger((String)this.category) : LoggerFactory.getLogger(LoggerMessageProcessor.class);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        this.log(event);
        return event;
    }

    protected void log(CoreEvent event) {
        if (event == null) {
            this.logWithLevel(null);
        } else if (StringUtils.isEmpty(this.message)) {
            this.logWithLevel(event.getMessage());
        } else {
            LogLevel logLevel = LogLevel.valueOf(this.level);
            if (LogLevel.valueOf(this.level).isEnabled(this.logger)) {
                logLevel.log(this.logger, this.expressionManager.parseLogTemplate(this.message, event, this.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT));
            }
        }
    }

    protected void logWithLevel(Object object) {
        LogLevel logLevel = LogLevel.valueOf(this.level);
        if (logLevel.isEnabled(this.logger)) {
            logLevel.log(this.logger, object);
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLevel(String level) {
        this.level = level.toUpperCase();
    }

    public static enum LogLevel {
        ERROR{

            @Override
            public void log(Logger logger, Object object) {
                logger.error(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isErrorEnabled();
            }
        }
        ,
        WARN{

            @Override
            public void log(Logger logger, Object object) {
                logger.warn(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isWarnEnabled();
            }
        }
        ,
        INFO{

            @Override
            public void log(Logger logger, Object object) {
                logger.info(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isInfoEnabled();
            }
        }
        ,
        DEBUG{

            @Override
            public void log(Logger logger, Object object) {
                logger.debug(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isDebugEnabled();
            }
        }
        ,
        TRACE{

            @Override
            public void log(Logger logger, Object object) {
                logger.trace(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isTraceEnabled();
            }
        };


        public abstract void log(Logger var1, Object var2);

        public abstract boolean isEnabled(Logger var1);
    }
}

