/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.store.PartitionableObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.routing.Aggregator;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelator;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.internal.util.rx.Operators;
import org.mule.runtime.core.internal.util.store.ProvidedObjectStoreWrapper;
import org.mule.runtime.core.internal.util.store.ProvidedPartitionableObjectStoreWrapper;
import org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public abstract class AbstractAggregator
extends AbstractInterceptingMessageProcessor
implements Initialisable,
MuleContextAware,
Aggregator,
Startable,
Stoppable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAggregator.class);
    public static final int MAX_PROCESSED_GROUPS = 50000;
    protected EventCorrelator eventCorrelator;
    private long timeout = 0L;
    private boolean failOnTimeout = true;
    private ObjectStore<Long> processedGroupsObjectStore;
    private PartitionableObjectStore eventGroupsObjectStore;
    protected boolean persistentStores;
    protected String storePrefix = null;
    protected String eventsObjectStoreKey;

    @Override
    public void initialise() throws InitialisationException {
        if (this.storePrefix == null) {
            this.storePrefix = String.format("%s%s.%s.", this.muleContext.getConfiguration().getId(), this.getLocation().getRootContainerName(), this.getClass().getName());
        }
        this.initProcessedGroupsObjectStore();
        this.initEventGroupsObjectStore();
        this.eventCorrelator = new EventCorrelator(this.getCorrelatorCallback(this.muleContext), this.next, this.muleContext, this.getFlowConstruct(), this.eventGroupsObjectStore, this.storePrefix, this.processedGroupsObjectStore);
        this.eventCorrelator.setTimeout(this.timeout);
        this.eventCorrelator.setFailOnTimeout(this.isFailOnTimeout());
    }

    protected void initProcessedGroupsObjectStore() {
        if (this.processedGroupsObjectStore == null) {
            this.processedGroupsObjectStore = new ProvidedObjectStoreWrapper<Long>(null, this.internalProcessedGroupsObjectStoreFactory());
        }
    }

    private Supplier<ObjectStore> internalProcessedGroupsObjectStoreFactory() {
        return () -> {
            ObjectStoreManager objectStoreManager = (ObjectStoreManager)((MuleContextWithRegistries)this.muleContext).getRegistry().get("_muleObjectStoreManager");
            return objectStoreManager.createObjectStore(this.storePrefix + ".processedGroups", ObjectStoreSettings.builder().persistent(this.persistentStores).maxEntries(50000).expirationInterval(1000L).build());
        };
    }

    protected void initEventGroupsObjectStore() throws InitialisationException {
        try {
            if (this.eventGroupsObjectStore == null) {
                this.eventGroupsObjectStore = new ProvidedPartitionableObjectStoreWrapper(null, this.internalEventsGroupsObjectStoreSupplier());
            }
            this.eventGroupsObjectStore.open(this.storePrefix + ".expiredAndDispatchedGroups");
            this.eventGroupsObjectStore.open(this.storePrefix + ".eventGroups");
        }
        catch (MuleRuntimeException | ObjectStoreException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private Supplier<ObjectStore> internalEventsGroupsObjectStoreSupplier() {
        return () -> {
            MuleRegistry registry = ((MuleContextWithRegistries)this.muleContext).getRegistry();
            ObjectStore objectStore = this.persistentStores ? (ObjectStore)registry.lookupObject("_defaultPersistentObjectStore") : (ObjectStore)registry.lookupObject("_defaultInMemoryObjectStore");
            if (objectStore instanceof MuleContextAware) {
                ((MuleContextAware)((Object)objectStore)).setMuleContext(this.muleContext);
            }
            return objectStore;
        };
    }

    @Override
    public void start() throws MuleException {
        if (this.timeout != 0L) {
            this.eventCorrelator.start();
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.timeout != 0L) {
            this.eventCorrelator.stop();
        }
    }

    protected abstract EventCorrelatorCallback getCorrelatorCallback(MuleContext var1);

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        CoreEvent result = this.eventCorrelator.process(event);
        if (result == null) {
            return null;
        }
        return this.processNext(result);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).handle(Operators.nullSafeMap(Exceptions.checkedFunction(event -> this.process((CoreEvent)event))));
    }

    @Override
    public void expireAggregation(String groupId) throws MuleException {
        this.eventCorrelator.forceGroupExpiry(groupId);
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    @Override
    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }

    public void setProcessedGroupsObjectStore(ObjectStore<Long> processedGroupsObjectStore) {
        this.processedGroupsObjectStore = new ProvidedObjectStoreWrapper<Long>(processedGroupsObjectStore, this.internalProcessedGroupsObjectStoreFactory());
    }

    public void setEventGroupsObjectStore(PartitionableObjectStore<CoreEvent> eventGroupsObjectStore) {
        this.eventGroupsObjectStore = new ProvidedPartitionableObjectStoreWrapper<CoreEvent>(eventGroupsObjectStore, this.internalEventsGroupsObjectStoreSupplier());
    }

    public boolean isPersistentStores() {
        return this.persistentStores;
    }

    public void setPersistentStores(boolean persistentStores) {
        this.persistentStores = persistentStores;
    }

    public String getStorePrefix() {
        return this.storePrefix;
    }

    public void setStorePrefix(String storePrefix) {
        this.storePrefix = storePrefix;
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.processedGroupsObjectStore, LOGGER);
        LifecycleUtils.disposeIfNeeded(this.eventGroupsObjectStore, LOGGER);
    }
}

