/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginExtendedDeploymentProperties;

public class ArtifactPluginDescriptorLoader {
    private final ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory;

    public ArtifactPluginDescriptorLoader(ArtifactPluginDescriptorFactory artifactPluginDescriptorFactory) {
        this.artifactPluginDescriptorFactory = artifactPluginDescriptorFactory;
    }

    public ArtifactPluginDescriptor load(File plugin) throws IOException {
        Preconditions.checkArgument(plugin != null, "plugin zip cannot be null");
        Preconditions.checkArgument(plugin.getName().endsWith("jar"), "plugin zip must be a zip file ending with .zip or .jar, but the file name was " + plugin.getAbsolutePath());
        return this.artifactPluginDescriptorFactory.create(plugin, Optional.empty());
    }

    public ArtifactPluginDescriptor load(File pluginFile, DeployableArtifactDescriptor deployableArtifactDescriptor) throws IOException {
        Preconditions.checkArgument(pluginFile != null, "plugin zip cannot be null");
        Preconditions.checkArgument(pluginFile.getName().endsWith("jar"), "plugin zip must be a zip file ending with .zip or .jar, but the file name was " + pluginFile.getAbsolutePath());
        return this.artifactPluginDescriptorFactory.create(pluginFile, Optional.of(new PluginExtendedDeploymentProperties(new Properties(), deployableArtifactDescriptor)));
    }
}

