/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources.manifest;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.resources.manifest.ClassPackageFinder;
import org.mule.runtime.module.extension.internal.resources.manifest.DefaultClassPackageFinder;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ExportedArtifactsCollector {
    private final Set<String> filteredPackages = ImmutableSet.builder().add((Object[])new String[]{"java.", "javax.", "org.mule.runtime.", "com.mulesoft.mule.runtime"}).build();
    private final ExtensionModel extensionModel;
    private final Set<String> exportedClasses = new LinkedHashSet<String>();
    private final Set<String> privilegedExportedPackages = new LinkedHashSet<String>();
    private final Set<String> privilegedArtifacts = new LinkedHashSet<String>();
    private final ClassPackageFinder packageFinder;

    public ExportedArtifactsCollector(ExtensionModel extensionModel) {
        this(extensionModel, new DefaultClassPackageFinder());
    }

    public ExportedArtifactsCollector(ExtensionModel extensionModel, ClassPackageFinder packageFinder) {
        this.extensionModel = extensionModel;
        this.packageFinder = packageFinder;
    }

    public Set<String> getExportedResources() {
        return this.extensionModel.getResources();
    }

    public Set<String> getExportedPackages() {
        this.collectDefault();
        this.collectManuallyExportedPackages();
        Set<String> exportedPackages = this.exportedClasses.stream().map(this.packageFinder::packageFor).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return this.filterExportedPackages(exportedPackages);
    }

    public Map<String, Collection<String>> getDetailedExportedPackages() {
        this.collectDefault();
        this.collectManuallyExportedPackages();
        HashMultimap exportedPackages = HashMultimap.create();
        this.exportedClasses.stream().map(clazz -> new Pair<String, String>(this.packageFinder.packageFor((String)clazz).orElse(""), (String)clazz)).filter(pair -> !StringUtils.isBlank((String)pair.getFirst())).filter(pair -> this.filteredPackages.stream().noneMatch(filteredPackage -> ((String)pair.getFirst()).startsWith((String)filteredPackage))).forEach(pair -> exportedPackages.put(pair.getFirst(), pair.getSecond()));
        return exportedPackages.asMap();
    }

    public Set<String> getPrivilegedExportedPackages() {
        this.privilegedExportedPackages.addAll(this.extensionModel.getPrivilegedPackages());
        return this.filterExportedPackages(this.privilegedExportedPackages);
    }

    public Set<String> getPrivilegedArtifacts() {
        this.privilegedArtifacts.addAll(this.extensionModel.getPrivilegedArtifacts());
        return this.privilegedArtifacts;
    }

    private Set<String> filterExportedPackages(Set<String> exportedPackages) {
        return exportedPackages.stream().filter(packageName -> this.filteredPackages.stream().noneMatch(packageName::startsWith)).collect(Collectors.toSet());
    }

    private void collectManuallyExportedPackages() {
        this.extensionModel.getTypes().forEach(t -> ExtensionMetadataTypeUtils.getId(t).ifPresent(this.exportedClasses::add));
    }

    private void collectDefault() {
        new ExtensionWalker(){

            @Override
            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                ExportedArtifactsCollector.this.exportedClasses.addAll(IntrospectionUtils.collectRelativeClassesAsString(model.getType()));
            }

            @Override
            public void onOperation(HasOperationModels owner, OperationModel model) {
                ExportedArtifactsCollector.this.collectReturnTypes(model);
                ExportedArtifactsCollector.this.collectExceptionTypes(model);
            }

            @Override
            public void onSource(HasSourceModels owner, SourceModel model) {
                ExportedArtifactsCollector.this.collectReturnTypes(model);
            }
        }.walk(this.extensionModel);
    }

    private void collectReturnTypes(ConnectableComponentModel model) {
        this.exportedClasses.addAll(IntrospectionUtils.collectRelativeClassesAsString(model.getOutput().getType()));
        this.exportedClasses.addAll(IntrospectionUtils.collectRelativeClassesAsString(model.getOutputAttributes().getType()));
    }

    private void collectExceptionTypes(OperationModel operationModel) {
        operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(ExtensionOperationDescriptorModelProperty::getOperationMethod).ifPresent(method -> this.exportedClasses.addAll(method.getExceptionTypes().stream().map(Type::getTypeName).collect(Collectors.toSet())));
    }
}

