/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.soap.generator.attachment;

import java.util.Map;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.soap.api.exception.SoapServiceException;
import org.mule.service.soap.util.XmlTransformationException;
import org.mule.service.soap.util.XmlTransformationUtils;
import org.mule.service.soap.xml.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AttachmentRequestEnricher {
    protected TypeLoader loader;

    AttachmentRequestEnricher(TypeLoader loader) {
        this.loader = loader;
    }

    public String enrichRequest(String body2, Map<String, SoapAttachment> attachments) {
        try {
            Document bodyDocument = XmlTransformationUtils.stringToDocument(body2);
            Element documentElement = bodyDocument.getDocumentElement();
            attachments.forEach((name, attachment) -> {
                Element attachmentElement = bodyDocument.createElement((String)name);
                this.addAttachmentElement(bodyDocument, (String)name, (SoapAttachment)attachment, attachmentElement);
                documentElement.appendChild(attachmentElement);
            });
            return XMLUtils.toXml(bodyDocument);
        }
        catch (XmlTransformationException e) {
            throw new SoapServiceException("Error while preparing request for the provided body", e);
        }
    }

    abstract void addAttachmentElement(Document var1, String var2, SoapAttachment var3, Element var4);
}

