/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import org.mule.weave.v2.exception.InvalidUnitException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.DateTimeValue;
import org.mule.weave.v2.model.values.DateTimeValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.TemporalCoercer;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.ast.structure.schema.TimeUnit$;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.util.Failure;
import scala.util.Try$;
import spire.math.Number;

public final class DateTimeCoercer$
implements ValueCoercer<DateTimeValue>,
TemporalCoercer<ZonedDateTime> {
    public static DateTimeCoercer$ MODULE$;
    private final TemporalQuery<ZonedDateTime> FROM;

    static {
        new DateTimeCoercer$();
    }

    @Override
    public Object stringCoercion(String str, TemporalQuery from, LocationCapable locationCapable, Option schema, EvaluationContext ctx) {
        return TemporalCoercer.stringCoercion$(this, str, from, locationCapable, schema, ctx);
    }

    @Override
    public Object parseTemporal(String str, String format, Locale locale, TemporalQuery from, LocationCapable locationCapable, EvaluationContext ctx) {
        return TemporalCoercer.parseTemporal$(this, str, format, locale, from, locationCapable, ctx);
    }

    @Override
    public Option<DateTimeValue> coerceMaybe(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetType, locationCapable, evaluationContext);
    }

    public TemporalQuery<ZonedDateTime> FROM() {
        return this.FROM;
    }

    @Override
    public DateTimeValue coerce(Value<?> c, Type targetType, LocationCapable locationCapable, EvaluationContext ctx) {
        Type type;
        Type type2;
        Type type3;
        ZonedDateTime zonedDateTime;
        Type type4;
        Option<Schema> schema = targetType.schema(ctx);
        Type type5 = c.valueType(ctx);
        if (type5 != null && (type4 = type5).isInstanceOf(NumberType$.MODULE$, ctx)) {
            zonedDateTime = this.numberCoercion((Number)c.evaluate(ctx), locationCapable, schema, ctx);
        } else if (type5 != null && (type3 = type5).isInstanceOf(DateTimeType$.MODULE$, ctx)) {
            zonedDateTime = (ZonedDateTime)c.evaluate(ctx);
        } else if (type5 != null && (type2 = type5).isInstanceOf(LocalDateTimeType$.MODULE$, ctx)) {
            zonedDateTime = ((LocalDateTime)c.evaluate(ctx)).atOffset(ZoneOffset.UTC).toZonedDateTime();
        } else if (type5 != null && (type = type5).isInstanceOf(StringType$.MODULE$, ctx)) {
            zonedDateTime = (ZonedDateTime)this.stringCoercion((String)c.evaluate(ctx), this.FROM(), locationCapable, (Option)schema, ctx);
        } else {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(ctx), targetType, c, ctx);
        }
        ZonedDateTime coercedValue = zonedDateTime;
        return DateTimeValue$.MODULE$.apply(coercedValue, locationCapable, targetType);
    }

    public ZonedDateTime numberCoercion(Number number, LocationCapable locationCapable, Option<Schema> mayBeSchema, EvaluationContext ctx) {
        Option dateTimeMaybe = mayBeSchema.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.unit(ctx)).map((Function1 & Serializable & scala.Serializable)unit -> DateTimeCoercer$.toDateTime$1(unit, number, locationCapable));
        return (ZonedDateTime)dateTimeMaybe.getOrElse((Function0 & Serializable & scala.Serializable)() -> DateTimeCoercer$.secondsToDateTime$1(number));
    }

    @Override
    public ZonedDateTime fallbackStringCoercion(String str, LocationCapable locationCapable, EvaluationContext ctx) {
        return (ZonedDateTime)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ZonedDateTime.parse(str)).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> LocalDateTime.parse(str).atZone(ZoneOffset.UTC))).orElse((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)new UnsupportedTypeCoercionException(locationCapable.location(), StringType$.MODULE$, DateTimeType$.MODULE$, str, UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$5(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx))).get();
    }

    @Override
    public Type targetType() {
        return DateTimeType$.MODULE$;
    }

    private static final ZonedDateTime secondsToDateTime$1(Number number$1) {
        return Instant.ofEpochSecond(number$1.toLong()).atZone(ZoneOffset.UTC);
    }

    private static final ZonedDateTime toDateTime$1(String unit, Number number$1, LocationCapable locationCapable$1) {
        ZonedDateTime zonedDateTime;
        String string = unit.toLowerCase();
        String string2 = TimeUnit$.MODULE$.MILLISECONDS();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            zonedDateTime = Instant.ofEpochMilli(number$1.toLong()).atZone(ZoneOffset.UTC);
        } else {
            String string4 = TimeUnit$.MODULE$.SECONDS();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                zonedDateTime = DateTimeCoercer$.secondsToDateTime$1(number$1);
            } else {
                throw new InvalidUnitException(locationCapable$1.location(), unit);
            }
        }
        return zonedDateTime;
    }

    private DateTimeCoercer$() {
        MODULE$ = this;
        ValueCoercer.$init$(this);
        TemporalCoercer.$init$(this);
        this.FROM = temporal -> ZonedDateTime.from(temporal);
    }
}

