/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.InnerProducer;
import reactor.core.publisher.OperatorDisposables;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;

final class FluxCreate<T>
extends Flux<T> {
    final Consumer<? super FluxSink<T>> source;
    final FluxSink.OverflowStrategy backpressure;
    final CreateMode createMode;

    FluxCreate(Consumer<? super FluxSink<T>> source, FluxSink.OverflowStrategy backpressure, CreateMode createMode) {
        this.source = Objects.requireNonNull(source, "source");
        this.backpressure = Objects.requireNonNull(backpressure, "backpressure");
        this.createMode = createMode;
    }

    static <T> BaseSink<T> createSink(CoreSubscriber<? super T> t, FluxSink.OverflowStrategy backpressure) {
        switch (backpressure) {
            case IGNORE: {
                return new IgnoreSink<T>(t);
            }
            case ERROR: {
                return new ErrorAsyncSink<T>(t);
            }
            case DROP: {
                return new DropAsyncSink<T>(t);
            }
            case LATEST: {
                return new LatestAsyncSink<T>(t);
            }
        }
        return new BufferAsyncSink<T>(t, Queues.SMALL_BUFFER_SIZE);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        BaseSink<T> sink = FluxCreate.createSink(actual, this.backpressure);
        actual.onSubscribe(sink);
        try {
            this.source.accept((FluxSink<BaseSink<T>>)((Object)(this.createMode == CreateMode.PUSH_PULL ? new SerializedSink<T>(sink) : sink)));
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            sink.error(Operators.onOperatorError(ex, actual.currentContext()));
        }
    }

    static final class SinkDisposable
    implements Disposable {
        Disposable onCancel;
        Disposable disposable;

        SinkDisposable(@Nullable Disposable disposable, @Nullable Disposable onCancel) {
            this.disposable = disposable;
            this.onCancel = onCancel;
        }

        @Override
        public void dispose() {
            if (this.disposable != null) {
                this.disposable.dispose();
            }
        }

        public void cancel() {
            if (this.onCancel != null) {
                this.onCancel.dispose();
            }
        }
    }

    static final class LatestAsyncSink<T>
    extends BaseSink<T> {
        final AtomicReference<T> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<LatestAsyncSink> WIP = AtomicIntegerFieldUpdater.newUpdater(LatestAsyncSink.class, "wip");

        LatestAsyncSink(CoreSubscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public FluxSink<T> next(T t) {
            this.queue.set(t);
            this.drain();
            return this;
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void complete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequestedFromDownstream() {
            this.drain();
        }

        @Override
        void onCancel() {
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            CoreSubscriber a = this.actual;
            AtomicReference<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                Operators.produced(REQUESTED, this, e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.get() == null ? 0 : 1;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            return super.scanUnsafe(key);
        }
    }

    static final class BufferAsyncSink<T>
    extends BaseSink<T> {
        final Queue<T> queue;
        Throwable error;
        volatile boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BufferAsyncSink> WIP = AtomicIntegerFieldUpdater.newUpdater(BufferAsyncSink.class, "wip");

        BufferAsyncSink(CoreSubscriber<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = Queues.unbounded(capacityHint).get();
        }

        @Override
        public FluxSink<T> next(T t) {
            this.queue.offer(t);
            this.drain();
            return this;
        }

        @Override
        public void error(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        @Override
        public void complete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequestedFromDownstream() {
            this.drain();
        }

        @Override
        void onCancel() {
            if (WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            CoreSubscriber a = this.actual;
            Queue<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    T o = q.poll();
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            super.error(ex);
                        } else {
                            super.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                Operators.produced(REQUESTED, this, e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.size();
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            return super.scanUnsafe(key);
        }
    }

    static final class ErrorAsyncSink<T>
    extends NoOverflowBaseAsyncSink<T> {
        ErrorAsyncSink(CoreSubscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
            this.error(Exceptions.failWithOverflow());
        }
    }

    static final class DropAsyncSink<T>
    extends NoOverflowBaseAsyncSink<T> {
        DropAsyncSink(CoreSubscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseAsyncSink<T>
    extends BaseSink<T> {
        NoOverflowBaseAsyncSink(CoreSubscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public final FluxSink<T> next(T t) {
            if (this.isCancelled()) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return this;
            }
            if (this.requested != 0L) {
                this.actual.onNext(t);
                Operators.produced(REQUESTED, this, 1L);
            } else {
                this.onOverflow();
            }
            return this;
        }

        abstract void onOverflow();
    }

    static final class IgnoreSink<T>
    extends BaseSink<T> {
        IgnoreSink(CoreSubscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public FluxSink<T> next(T t) {
            long r;
            if (this.isCancelled()) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return this;
            }
            this.actual.onNext(t);
            while ((r = this.requested) != 0L && !REQUESTED.compareAndSet(this, r, r - 1L)) {
            }
            return this;
        }
    }

    static abstract class BaseSink<T>
    extends AtomicBoolean
    implements FluxSink<T>,
    InnerProducer<T> {
        final CoreSubscriber<? super T> actual;
        volatile Disposable disposable;
        static final AtomicReferenceFieldUpdater<BaseSink, Disposable> DISPOSABLE = AtomicReferenceFieldUpdater.newUpdater(BaseSink.class, Disposable.class, "disposable");
        volatile long requested;
        static final AtomicLongFieldUpdater<BaseSink> REQUESTED = AtomicLongFieldUpdater.newUpdater(BaseSink.class, "requested");
        volatile LongConsumer requestConsumer;
        static final AtomicReferenceFieldUpdater<BaseSink, LongConsumer> REQUEST_CONSUMER = AtomicReferenceFieldUpdater.newUpdater(BaseSink.class, LongConsumer.class, "requestConsumer");

        BaseSink(CoreSubscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public Context currentContext() {
            return this.actual.currentContext();
        }

        @Override
        public void complete() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.actual.onComplete();
            }
            finally {
                this.disposeResource(false);
            }
        }

        @Override
        public void error(Throwable e) {
            if (this.isCancelled()) {
                Operators.onErrorDropped(e, this.actual.currentContext());
                return;
            }
            try {
                this.actual.onError(e);
            }
            finally {
                this.disposeResource(false);
            }
        }

        public final void cancel() {
            this.disposeResource(true);
            this.onCancel();
        }

        void disposeResource(boolean isCancel) {
            Disposable d = this.disposable;
            if (d != OperatorDisposables.DISPOSED && (d = DISPOSABLE.getAndSet(this, OperatorDisposables.DISPOSED)) != null && d != OperatorDisposables.DISPOSED) {
                if (isCancel && d instanceof SinkDisposable) {
                    ((SinkDisposable)d).cancel();
                }
                d.dispose();
            }
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        void onCancel() {
        }

        @Override
        public final boolean isCancelled() {
            return OperatorDisposables.isDisposed(this.disposable);
        }

        public final void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
                LongConsumer consumer = this.requestConsumer;
                if (n > 0L && consumer != null && !this.isCancelled()) {
                    consumer.accept(n);
                }
                this.onRequestedFromDownstream();
            }
        }

        void onRequestedFromDownstream() {
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public FluxSink<T> onRequest(LongConsumer consumer) {
            Objects.requireNonNull(consumer, "onRequest");
            this.onRequest(consumer, n -> {}, Long.MAX_VALUE);
            return this;
        }

        protected void onRequest(LongConsumer initialRequestConsumer, LongConsumer requestConsumer, long value) {
            if (!REQUEST_CONSUMER.compareAndSet(this, null, requestConsumer)) {
                throw new IllegalStateException("A consumer has already been assigned to consume requests");
            }
            if (value > 0L) {
                initialRequestConsumer.accept(value);
            }
        }

        @Override
        public final FluxSink<T> onCancel(Disposable d) {
            Disposable c;
            Objects.requireNonNull(d, "onCancel");
            SinkDisposable sd = new SinkDisposable(null, d);
            if (!DISPOSABLE.compareAndSet(this, null, sd) && (c = this.disposable) instanceof SinkDisposable) {
                SinkDisposable current = (SinkDisposable)c;
                if (current.onCancel == null) {
                    current.onCancel = d;
                } else {
                    d.dispose();
                }
            }
            return this;
        }

        @Override
        public final FluxSink<T> onDispose(Disposable d) {
            Objects.requireNonNull(d, "onDispose");
            SinkDisposable sd = new SinkDisposable(d, null);
            if (!DISPOSABLE.compareAndSet(this, null, sd)) {
                Disposable c = this.disposable;
                if (c == OperatorDisposables.DISPOSED) {
                    d.dispose();
                } else if (c instanceof SinkDisposable) {
                    SinkDisposable current = (SinkDisposable)c;
                    if (current.disposable == null) {
                        current.disposable = d;
                    } else {
                        d.dispose();
                    }
                }
            }
            return this;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return OperatorDisposables.isDisposed(this.disposable);
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            return InnerProducer.super.scanUnsafe(key);
        }
    }

    static class SerializeOnRequestSink<T>
    implements FluxSink<T>,
    Scannable {
        final BaseSink<T> baseSink;
        SerializedSink<T> serializedSink;
        FluxSink<T> sink;

        SerializeOnRequestSink(BaseSink<T> sink) {
            this.baseSink = sink;
            this.sink = sink;
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            return this.serializedSink != null ? this.serializedSink.scanUnsafe(key) : this.baseSink.scanUnsafe(key);
        }

        @Override
        public void complete() {
            this.sink.complete();
        }

        @Override
        public void error(Throwable e) {
            this.sink.error(e);
        }

        @Override
        public FluxSink<T> next(T t) {
            this.sink.next(t);
            return this.serializedSink == null ? this : this.serializedSink;
        }

        @Override
        public long requestedFromDownstream() {
            return this.sink.requestedFromDownstream();
        }

        @Override
        public boolean isCancelled() {
            return this.sink.isCancelled();
        }

        @Override
        public FluxSink<T> onRequest(LongConsumer consumer) {
            if (this.serializedSink == null) {
                this.serializedSink = new SerializedSink<T>(this.baseSink);
                this.sink = this.serializedSink;
            }
            return this.sink.onRequest(consumer);
        }

        @Override
        public FluxSink<T> onCancel(Disposable d) {
            this.sink.onCancel(d);
            return this.sink;
        }

        @Override
        public FluxSink<T> onDispose(Disposable d) {
            this.sink.onDispose(d);
            return this;
        }
    }

    static final class SerializedSink<T>
    implements FluxSink<T>,
    Scannable {
        final BaseSink<T> sink;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<SerializedSink, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(SerializedSink.class, Throwable.class, "error");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SerializedSink> WIP = AtomicIntegerFieldUpdater.newUpdater(SerializedSink.class, "wip");
        final Queue<T> queue;
        volatile boolean done;

        SerializedSink(BaseSink<T> sink) {
            this.sink = sink;
            this.queue = Queues.unbounded(16).get();
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FluxSink<T> next(T t) {
            Objects.requireNonNull(t, "t is null in sink.next(t)");
            if (this.sink.isCancelled() || this.done) {
                Operators.onNextDropped(t, this.sink.currentContext());
                return this;
            }
            if (WIP.get(this) == 0 && WIP.compareAndSet(this, 0, 1)) {
                try {
                    this.sink.next(t);
                }
                catch (Throwable ex) {
                    Operators.onOperatorError(this.sink, ex, t, this.sink.currentContext());
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return this;
                }
            } else {
                Queue<T> q = this.queue;
                SerializedSink serializedSink = this;
                synchronized (serializedSink) {
                    q.offer(t);
                }
                if (WIP.getAndIncrement(this) != 0) {
                    return this;
                }
            }
            this.drainLoop();
            return this;
        }

        @Override
        public void error(Throwable t) {
            Objects.requireNonNull(t, "t is null in sink.error(t)");
            if (this.sink.isCancelled() || this.done) {
                Operators.onErrorDropped(t, this.sink.currentContext());
                return;
            }
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t, this.sink.currentContext());
            }
        }

        @Override
        public void complete() {
            if (this.sink.isCancelled() || this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            BaseSink<T> e = this.sink;
            Queue<T> q = this.queue;
            int missed = 1;
            while (true) {
                boolean empty;
                if (e.isCancelled()) {
                    q.clear();
                    return;
                }
                if (ERROR.get(this) != null) {
                    q.clear();
                    e.error(Exceptions.terminate(ERROR, this));
                    return;
                }
                boolean d = this.done;
                T v = q.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    e.complete();
                    return;
                }
                if (!empty) {
                    try {
                        e.next(v);
                    }
                    catch (Throwable ex) {
                        Operators.onOperatorError(this.sink, ex, v, this.sink.currentContext());
                    }
                    continue;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        @Override
        public FluxSink<T> onRequest(LongConsumer consumer) {
            this.sink.onRequest(consumer, consumer, this.sink.requested);
            return this;
        }

        @Override
        public FluxSink<T> onCancel(Disposable d) {
            this.sink.onCancel(d);
            return this;
        }

        @Override
        public FluxSink<T> onDispose(Disposable d) {
            this.sink.onDispose(d);
            return this;
        }

        @Override
        public long requestedFromDownstream() {
            return this.sink.requestedFromDownstream();
        }

        @Override
        public boolean isCancelled() {
            return this.sink.isCancelled();
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.size();
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            return this.sink.scanUnsafe(key);
        }
    }

    static enum CreateMode {
        PUSH_ONLY,
        PUSH_PULL;

    }
}

