/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.api;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.raml.internal.RamlTypeLoader;
import org.mule.metadata.raml.internal.TypeDeclarationTypeLoader;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.metadata.xml.api.utils.XmlSchemaUtils;

public class XmlRamlTypeLoader
implements TypeLoader {
    private final RamlTypeLoader ramlTypeLoader;

    public XmlRamlTypeLoader(File ramlFile) {
        this.ramlTypeLoader = new RamlTypeLoader(ramlFile, this.createXmlTypeDeclarationTypeLoader());
    }

    public XmlRamlTypeLoader(String content, String ramlLocation) {
        this.ramlTypeLoader = new RamlTypeLoader(content, ramlLocation, this.createXmlTypeDeclarationTypeLoader());
    }

    private TypeDeclarationTypeLoader createXmlTypeDeclarationTypeLoader() {
        return (typeDeclaration, typeIdentifier, typeAlias) -> {
            String schemaContent = typeDeclaration.toXmlSchema();
            XmlTypeLoader xmlTypeLoader = new XmlTypeLoader(SchemaCollector.getInstance().addSchema("", schemaContent));
            Optional<QName> xmlSchemaRootElementName = XmlSchemaUtils.getXmlSchemaRootElementName(Arrays.asList(schemaContent), "");
            return xmlSchemaRootElementName.flatMap(qName -> xmlTypeLoader.load((QName)xmlSchemaRootElementName.get(), typeAlias));
        };
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.ramlTypeLoader.load(typeIdentifier, typeAlias);
    }
}

