/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringEscapeUtils;
import org.mule.apache.xerces.dom.DOMInputImpl;
import org.mule.apache.xerces.impl.xs.XSImplementationImpl;
import org.mule.apache.xerces.impl.xs.XSLoaderImpl;
import org.mule.apache.xerces.impl.xs.util.LSInputListImpl;
import org.mule.apache.xerces.xs.XSLoader;
import org.mule.apache.xerces.xs.XSModel;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.xml.api.ModelFactoryFromExampleSupport;
import org.mule.metadata.xml.api.utils.SchemaHelper;
import org.mule.metadata.xml.api.utils.XmlSchemaUtils;
import org.w3c.dom.ls.LSInput;

public class ModelFactory {
    private XSModel model;
    private Optional<QName> rootElementName;
    private Optional<ExampleAnnotation> example;

    private ModelFactory(XSModel model, ExampleAnnotation example, QName rootElementName) {
        this.model = model;
        this.example = Optional.ofNullable(example);
        this.rootElementName = Optional.ofNullable(rootElementName);
    }

    public static ModelFactory fromExample(File exampleFile) {
        try {
            return ModelFactory.fromExample(Files.readAllLines(exampleFile.toPath()).stream().collect(Collectors.joining()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ModelFactory fromExample(String exampleXML) {
        List<String> schemas;
        XSLoader schemaLoader;
        try {
            schemaLoader = ModelFactory.initializeXSLoader();
            schemas = SchemaHelper.generateXSD(exampleXML);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generated XSD schemas.", e);
        }
        if (schemas.size() > 1) {
            try {
                schemas = ModelFactoryFromExampleSupport.fixForMultipleSchemas(schemaLoader, schemas);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to configure XSD loader.", e);
            }
        }
        try {
            LSInput[] domInputs = (DOMInputImpl[])schemas.stream().map(schema -> new DOMInputImpl(null, null, null, new StringReader((String)schema), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList(new LSInputListImpl(domInputs, domInputs.length));
            Optional<QName> rootElementName = XmlSchemaUtils.getXmlSchemaRootElementName(schemas, exampleXML);
            return new ModelFactory(model, new ExampleAnnotation(StringEscapeUtils.escapeXml11((String)exampleXML)), rootElementName.orElse(null));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate metadatatype from XSD.", e);
        }
    }

    public static ModelFactory fromSchemas(Map<String, InputStream> schemasMap) {
        try {
            XSLoader schemaLoader = ModelFactory.initializeXSLoader();
            XSLoaderImpl myLoader = (XSLoaderImpl)schemaLoader;
            ArrayList errors = new ArrayList();
            myLoader.setParameter("http://apache.org/xml/features/disallow-doctype-decl", true);
            myLoader.setParameter("error-handler", error -> {
                errors.add(error.getMessage());
                return false;
            });
            LSInput[] domInputs = (DOMInputImpl[])schemasMap.entrySet().stream().map(schema -> new DOMInputImpl(null, (String)schema.getKey(), null, (InputStream)schema.getValue(), "UTF-8")).toArray(DOMInputImpl[]::new);
            XSModel model = schemaLoader.loadInputList(new LSInputListImpl(domInputs, domInputs.length));
            if (model == null) {
                throw new RuntimeException("Failed while trying to load schema errors " + errors.stream().reduce("", (value, acc) -> value + ", " + acc));
            }
            return new ModelFactory(model, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static XSLoader initializeXSLoader() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        XSImplementationImpl impl = new XSImplementationImpl();
        return impl.createXSLoader(null);
    }

    XSModel getModel() {
        return this.model;
    }

    public Optional<QName> getRootElementName() {
        return this.rootElementName;
    }

    public Optional<ExampleAnnotation> getExample() {
        return this.example;
    }
}

