/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.object;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.InitialisationCallback;
import org.mule.runtime.core.api.object.ObjectFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.privileged.util.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectFactory
extends AbstractComponent
implements ObjectFactory {
    protected String objectClassName;
    protected Class<?> objectClass;
    protected Map properties = null;
    protected List<InitialisationCallback> initialisationCallbacks = new ArrayList<InitialisationCallback>();
    protected FlowConstruct flowConstruct;
    protected boolean disposed = false;
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public AbstractObjectFactory() {
    }

    public AbstractObjectFactory(String objectClassName) {
        this(objectClassName, null);
    }

    public AbstractObjectFactory(String objectClassName, Map properties) {
        this.objectClassName = objectClassName;
        this.properties = properties;
        this.setupObjectClassFromObjectClassName();
    }

    public AbstractObjectFactory(Class<?> objectClass) {
        this(objectClass, null);
    }

    public AbstractObjectFactory(Class<?> objectClass, Map properties) {
        this.objectClassName = objectClass.getName();
        this.objectClass = objectClass;
        this.properties = properties;
    }

    protected Class<?> setupObjectClassFromObjectClassName() {
        try {
            Class klass;
            this.objectClass = klass = org.apache.commons.lang3.ClassUtils.getClass((String)this.objectClassName);
            return klass;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.objectClassName == null || this.objectClass == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        this.disposed = false;
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    @Override
    public Object getInstance(MuleContext muleContext) throws Exception {
        if (this.objectClass == null || this.disposed) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        Object object = ClassUtils.instantiateClass(this.objectClass, new Object[0]);
        if (this.properties != null) {
            BeanUtils.populateWithoutFail(object, this.properties, true);
        }
        if (this.isAutoWireObject()) {
            ((MuleContextWithRegistries)muleContext).getRegistry().applyProcessors(object);
        }
        this.fireInitialisationCallbacks(object);
        return object;
    }

    protected void fireInitialisationCallbacks(Object component) throws InitialisationException {
        for (InitialisationCallback callback : this.initialisationCallbacks) {
            callback.initialise(component);
        }
    }

    @Override
    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
        this.objectClassName = objectClass.getName();
    }

    protected String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
        this.setupObjectClassFromObjectClassName();
    }

    protected Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    @Override
    public void addObjectInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public boolean isExternallyManagedLifecycle() {
        return false;
    }

    @Override
    public boolean isAutoWireObject() {
        return true;
    }
}

