/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.transaction.TransactionManager;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.SingleResourceTransactionFactoryManager;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.bootstrap.BootstrapServiceDiscoverer;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.connector.ConnectException;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.RollbackSourceCallback;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.ProcessingTimeWatcher;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.transformer.DataTypeConversionResolver;
import org.mule.runtime.core.api.util.StreamCloserService;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.api.util.queue.QueueManager;
import org.mule.runtime.core.internal.config.ClusterConfiguration;
import org.mule.runtime.core.internal.config.DefaultCustomizationService;
import org.mule.runtime.core.internal.config.NullClusterConfiguration;
import org.mule.runtime.core.internal.connector.DefaultSchedulerController;
import org.mule.runtime.core.internal.connector.SchedulerController;
import org.mule.runtime.core.internal.context.MuleContextWithRegistries;
import org.mule.runtime.core.internal.exception.ErrorHandler;
import org.mule.runtime.core.internal.exception.ErrorHandlerFactory;
import org.mule.runtime.core.internal.lifecycle.LifecycleInterceptor;
import org.mule.runtime.core.internal.lifecycle.MuleContextLifecycleManager;
import org.mule.runtime.core.internal.lifecycle.MuleLifecycleInterceptor;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.internal.registry.RegistryBroker;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.internal.util.JdkVersionUtils;
import org.mule.runtime.core.internal.util.splash.ArtifactShutdownSplashScreen;
import org.mule.runtime.core.internal.util.splash.ArtifactStartupSplashScreen;
import org.mule.runtime.core.internal.util.splash.ServerShutdownSplashScreen;
import org.mule.runtime.core.internal.util.splash.ServerStartupSplashScreen;
import org.mule.runtime.core.internal.util.splash.SplashScreen;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Hooks;

public class DefaultMuleContext
implements MuleContextWithRegistries,
PrivilegedMuleContext {
    public static final String LOCAL_OBJECT_STORE_MANAGER_KEY = "_muleLocalObjectStoreManager";
    public static final String LOCAL_QUEUE_MANAGER_KEY = "_localQueueManager";
    public static final ThreadLocal<MuleContext> currentMuleContext = new ThreadLocal();
    private static Logger logger = LoggerFactory.getLogger(DefaultMuleContext.class);
    private CustomizationService customizationService = new DefaultCustomizationService();
    private RegistryBroker registryBroker;
    private MuleRegistry muleRegistryHelper;
    private Injector injector;
    private AllStatistics stats = new AllStatistics();
    private volatile SchedulerService schedulerService;
    private MuleContextLifecycleManager lifecycleManager;
    private Object lifecycleStateLock = new Object();
    private ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private String id;
    private long startDate;
    private volatile StreamCloserService streamCloserService;
    private Object streamCloserServiceLock = new Object();
    private ClassLoader executionClassLoader;
    protected SystemExceptionHandler exceptionListener;
    private SchedulerController schedulerController = new DefaultSchedulerController();
    private ClusterConfiguration clusterConfiguration = new NullClusterConfiguration();
    private String clusterNodeIdPrefix = "";
    private SingleResourceTransactionFactoryManager singleResourceTransactionFactoryManager = new SingleResourceTransactionFactoryManager();
    private LockFactory lockFactory;
    private ExtendedExpressionManager expressionManager;
    private ProcessingTimeWatcher processingTimeWatcher;
    private final Latch startLatch = new Latch();
    private QueueManager queueManager;
    private ExtensionManager extensionManager;
    private ObjectSerializer objectSerializer;
    private volatile DataTypeConversionResolver dataTypeConversionResolver;
    private Object dataTypeConversionResolverLock = new Object();
    private volatile FlowTraceManager flowTraceManager;
    private Object flowTraceManagerLock = new Object();
    private volatile EventContextService eventContextService;
    private Object eventContextServiceLock = new Object();
    private volatile Collection<ExceptionContextProvider> exceptionContextProviders;
    private Object exceptionContextProvidersLock = new Object();
    private TransformationService transformationService;
    private BootstrapServiceDiscoverer bootstrapServiceDiscoverer;
    private Properties deploymentProperties;
    private List<MuleContextListener> listeners = new ArrayList<MuleContextListener>();
    private LifecycleInterceptor lifecycleInterceptor = new MuleLifecycleInterceptor();
    @Inject
    private ComponentInitialStateManager componentInitialStateManager;
    private ArtifactType artifactType;
    private ErrorTypeLocator errorTypeLocator;
    private ErrorTypeRepository errorTypeRepository;
    private ConfigurationComponentLocator componentLocator;

    public DefaultMuleContext() {
        this.transformationService = new ExtendedTransformationService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            this.lifecycleManager.checkPhase("initialise");
            if (this.getNotificationManager() == null) {
                throw new MuleRuntimeException(CoreMessages.objectIsNull("_muleNotificationManager"));
            }
            try {
                JdkVersionUtils.validateJdk();
            }
            catch (RuntimeException e) {
                throw new InitialisationException(CoreMessages.invalidJdk(SystemUtils.JAVA_VERSION, JdkVersionUtils.getSupportedJdks()), (Initialisable)this);
            }
            try {
                this.id = this.getConfiguration().getDomainId() + "." + this.getClusterId() + "." + this.getConfiguration().getId();
                this.getRegistry().initialise();
                this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
                this.getLifecycleManager().fireLifecycle("initialise");
                this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
                this.listeners.forEach(l -> l.onInitialization(this, this.getApiRegistry()));
                LifecycleUtils.initialiseIfNeeded(this.getExceptionListener(), true, (MuleContext)this);
                this.getNotificationManager().initialise();
                this.objectSerializer = (ObjectSerializer)this.registryBroker.get("_muleDefaultObjectSerializer");
            }
            catch (InitialisationException e) {
                this.dispose();
                throw e;
            }
            catch (Exception e) {
                this.dispose();
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            this.getLifecycleManager().checkPhase("start");
            if (this.getQueueManager() == null) {
                throw new MuleRuntimeException(CoreMessages.objectIsNull("queueManager"));
            }
            this.componentInitialStateManager = (ComponentInitialStateManager)this.muleRegistryHelper.get("_muleComponentInitialStateManager");
            this.startDate = System.currentTimeMillis();
            LifecycleUtils.startIfNeeded(this.extensionManager);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
            this.getLifecycleManager().fireLifecycle("start");
            this.overridePollingController();
            this.overrideClusterConfiguration();
            this.startMessageSources();
            this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
            this.listeners.forEach(l -> l.onStart(this, this.getApiRegistry()));
            this.startLatch.release();
            if (logger.isInfoEnabled()) {
                SplashScreen startupScreen = this.buildStartupSplash();
                logger.info(startupScreen.toString());
            }
        }
    }

    private void startMessageSources() throws LifecycleException {
        this.startPipelineMessageSources();
    }

    private void startPipelineMessageSources() throws LifecycleException {
        for (Pipeline pipeline : this.getRegistry().lookupObjectsForLifecycle(Pipeline.class)) {
            MessageSource messageSource;
            if (!pipeline.getLifecycleState().isStarted() || (messageSource = pipeline.getSource()) == null || !this.componentInitialStateManager.mustStartMessageSource(messageSource)) continue;
            this.startMessageSource(messageSource);
        }
    }

    private void startMessageSource(MessageSource messageSource) throws LifecycleException {
        try {
            LifecycleUtils.startIfNeeded(messageSource);
        }
        catch (ConnectException e) {
            this.exceptionListener.handleException(e);
        }
        catch (LifecycleException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LifecycleException(e, (Object)messageSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            this.startLatch.release();
            LifecycleUtils.stopIfNeeded(this.extensionManager);
            this.getLifecycleManager().checkPhase("stop");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
            this.getLifecycleManager().fireLifecycle("stop");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
            this.listeners.forEach(l -> l.onStop(this, this.getApiRegistry()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            if (this.isStarted() || this.lifecycleManager.getLastPhaseExecuted() != null && this.lifecycleManager.getLastPhaseExecuted().equals("start") && this.lifecycleManager.isLastPhaseExecutionFailed()) {
                try {
                    this.stop();
                }
                catch (MuleException e) {
                    logger.error("Failed to stop Mule context", (Throwable)e);
                }
            }
            this.getLifecycleManager().checkPhase("dispose");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
            LifecycleUtils.disposeIfNeeded(this.getExceptionListener(), logger);
            try {
                this.getLifecycleManager().fireLifecycle("dispose");
                if (this.muleRegistryHelper != null) {
                    FunctionalUtils.safely(() -> this.muleRegistryHelper.dispose());
                }
            }
            catch (Exception e) {
                logger.debug("Failed to cleanly dispose Mule: " + e.getMessage(), (Throwable)e);
            }
            this.notificationManager.fireNotification(new MuleContextNotification((MuleContext)this, 108));
            this.disposeManagers();
            if (this.getStartDate() > 0L && logger.isInfoEnabled()) {
                SplashScreen shutdownScreen = this.buildShutdownSplash();
                logger.info(shutdownScreen.toString());
            }
            this.setExecutionClassLoader(null);
        }
    }

    private void disposeManagers() {
        FunctionalUtils.safely(() -> {
            LifecycleUtils.disposeIfNeeded(this.getFlowTraceManager(), logger);
            this.notificationManager.dispose();
        });
    }

    @Override
    public boolean isInitialised() {
        return this.getLifecycleManager().getState().isInitialised();
    }

    @Override
    public boolean isInitialising() {
        return this.getLifecycleManager().getState().isInitialising();
    }

    @Override
    public boolean isStopped() {
        return this.getLifecycleManager().getState().isStopped();
    }

    @Override
    public boolean isStopping() {
        return this.getLifecycleManager().getState().isStopping();
    }

    @Override
    public boolean isStarted() {
        return this.getLifecycleManager().isPhaseComplete("start");
    }

    @Override
    public boolean isStarting() {
        return this.getLifecycleManager().getState().isStarting();
    }

    @Override
    public boolean isDisposed() {
        return this.getLifecycleManager().getState().isDisposed();
    }

    @Override
    public boolean isDisposing() {
        return this.getLifecycleManager().getState().isDisposing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withLifecycleLock(Runnable command) {
        Object object = this.lifecycleStateLock;
        synchronized (object) {
            command.run();
        }
    }

    @Override
    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    @Override
    public AllStatistics getStatistics() {
        return this.stats;
    }

    private void fireNotification(AbstractServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (logger.isDebugEnabled()) {
            logger.debug("MuleEvent Manager is not enabled, ignoring notification: " + notification);
        }
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        try {
            this.muleRegistryHelper.registerObject("_muleSecurityManager", securityManager);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(e);
        }
    }

    @Override
    public SecurityManager getSecurityManager() {
        Collection<SecurityManager> temp;
        SecurityManager securityManager = (SecurityManager)this.muleRegistryHelper.lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.muleRegistryHelper.lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = temp.iterator().next();
        }
        if (securityManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("securityManager"));
        }
        return securityManager;
    }

    @Override
    public SchedulerService getSchedulerService() {
        if (this.schedulerService == null) {
            try {
                this.schedulerService = this.getRegistry().lookupObject(SchedulerService.class);
                Objects.requireNonNull(this.schedulerService);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException(e);
            }
        }
        return this.schedulerService;
    }

    @Override
    public SchedulerConfig getSchedulerBaseConfig() {
        return (SchedulerConfig)this.getRegistry().lookupObject("_muleSchedulerBaseConfig");
    }

    @Override
    public QueueManager getQueueManager() {
        if (this.queueManager == null) {
            Collection<QueueManager> temp;
            this.queueManager = (QueueManager)this.registryBroker.lookupObject("_muleQueueManager");
            if (this.queueManager == null && (temp = this.registryBroker.lookupObjects(QueueManager.class)).size() > 0) {
                this.queueManager = temp.iterator().next();
            }
        }
        return this.queueManager;
    }

    @Override
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public LifecycleInterceptor getLifecycleInterceptor() {
        return this.lifecycleInterceptor;
    }

    @Override
    public ObjectStoreManager getObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject("_muleObjectStoreManager");
    }

    @Override
    public ObjectSerializer getObjectSerializer() {
        return this.objectSerializer;
    }

    public ObjectStoreManager getLocalObjectStoreManager() {
        return (ObjectStoreManager)this.getRegistry().lookupObject(LOCAL_OBJECT_STORE_MANAGER_KEY);
    }

    public QueueManager getLocalQueueManager() {
        return (QueueManager)this.getRegistry().lookupObject(LOCAL_QUEUE_MANAGER_KEY);
    }

    @Override
    public void setQueueManager(QueueManager queueManager) {
        try {
            this.getRegistry().registerObject("_muleQueueManager", queueManager);
        }
        catch (RegistrationException e) {
            throw new MuleRuntimeException(e);
        }
        this.queueManager = queueManager;
    }

    @Override
    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    @Override
    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.registryBroker.registerObject("_muleTransactionManager", manager);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return (TransactionManager)this.getRegistry().lookupObject("_muleTransactionManager");
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has already been through the " + phase + " phase.");
        }
    }

    @Override
    public MuleRegistry getRegistry() {
        return this.muleRegistryHelper;
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamCloserService getStreamCloserService() {
        if (this.streamCloserService == null) {
            Object object = this.streamCloserServiceLock;
            synchronized (object) {
                if (this.streamCloserService == null) {
                    this.streamCloserService = (StreamCloserService)this.getRegistry().lookupObject("_muleStreamCloserService");
                }
            }
        }
        return this.streamCloserService;
    }

    @Override
    public long getStartDate() {
        return this.startDate;
    }

    @Override
    public void setExecutionClassLoader(ClassLoader cl) {
        this.executionClassLoader = cl;
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }

    @Override
    @Deprecated
    public void addRegistry(Registry registry) {
        this.registryBroker.addRegistry(registry);
    }

    @Override
    @Deprecated
    public void removeRegistry(Registry registry) {
        this.registryBroker.removeRegistry(registry);
    }

    private SplashScreen buildStartupSplash() {
        SplashScreen startupScreen = this.config.isContainerMode() ? new ArtifactStartupSplashScreen() : new ServerStartupSplashScreen();
        startupScreen.setHeader(this);
        startupScreen.setFooter(this);
        return startupScreen;
    }

    private SplashScreen buildShutdownSplash() {
        SplashScreen shutdownScreen = this.config.isContainerMode() ? new ArtifactShutdownSplashScreen() : new ServerShutdownSplashScreen();
        shutdownScreen.setHeader(this);
        return shutdownScreen;
    }

    @Override
    public void handleException(Exception e, RollbackSourceCallback rollbackMethod) {
        this.getExceptionListener().handleException(e, rollbackMethod);
    }

    @Override
    public void handleException(Exception e) {
        this.handleException(e, null);
    }

    @Override
    public SystemExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(SystemExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public String getClusterId() {
        return this.clusterConfiguration.getClusterId();
    }

    @Override
    public int getClusterNodeId() {
        return this.clusterConfiguration.getClusterNodeId();
    }

    public void setSchedulerController(SchedulerController schedulerController) {
        this.schedulerController = schedulerController;
    }

    @Override
    public boolean isPrimaryPollingInstance() {
        return this.schedulerController.isPrimarySchedulingInstance();
    }

    @Override
    public String getUniqueIdString() {
        return UUID.getClusterUUID(this.clusterNodeIdPrefix);
    }

    @Override
    public FlowExceptionHandler getDefaultErrorHandler(Optional<String> rootContainerName) {
        FlowExceptionHandler defaultErrorHandler;
        if (this.config.getDefaultErrorHandlerName() != null) {
            defaultErrorHandler = (FlowExceptionHandler)this.getRegistry().lookupObject(this.config.getDefaultErrorHandlerName());
            if (defaultErrorHandler == null) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("No global error handler named %s", this.config.getDefaultErrorHandlerName())));
            }
        } else {
            try {
                defaultErrorHandler = new ErrorHandlerFactory().createDefault(this.getRegistry().lookupObject(NotificationDispatcher.class));
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException(e);
            }
        }
        if (rootContainerName.isPresent() && defaultErrorHandler instanceof ErrorHandler) {
            ((ErrorHandler)defaultErrorHandler).setRootContainerName(rootContainerName.get());
        }
        return defaultErrorHandler;
    }

    @Override
    public SingleResourceTransactionFactoryManager getTransactionFactoryManager() {
        return this.singleResourceTransactionFactoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeConversionResolver getDataTypeConverterResolver() {
        if (this.dataTypeConversionResolver == null) {
            Object object = this.dataTypeConversionResolverLock;
            synchronized (object) {
                if (this.dataTypeConversionResolver == null) {
                    this.dataTypeConversionResolver = (DataTypeConversionResolver)this.getRegistry().lookupObject("_converterResolver");
                    if (this.dataTypeConversionResolver == null) {
                        this.dataTypeConversionResolver = new DynamicDataTypeConversionResolver(this);
                        try {
                            this.getRegistry().registerObject("_converterResolver", this.dataTypeConversionResolver);
                        }
                        catch (RegistrationException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                }
            }
        }
        return this.dataTypeConversionResolver;
    }

    @Override
    public ExtendedExpressionManager getExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = (ExtendedExpressionManager)this.registryBroker.lookupObject("_muleExpressionManager");
        }
        return this.expressionManager;
    }

    @Override
    public LockFactory getLockFactory() {
        if (this.lockFactory == null) {
            this.lockFactory = (LockFactory)this.registryBroker.get("_muleLockFactory");
        }
        return this.lockFactory;
    }

    @Override
    public ProcessingTimeWatcher getProcessorTimeWatcher() {
        if (this.processingTimeWatcher == null) {
            this.processingTimeWatcher = (ProcessingTimeWatcher)this.registryBroker.get("_muleProcessingTimeWatcher");
        }
        return this.processingTimeWatcher;
    }

    @Override
    public boolean waitUntilStarted(int timeout) throws InterruptedException {
        return this.startLatch.await(timeout, TimeUnit.MILLISECONDS);
    }

    private void overrideClusterConfiguration() {
        ClusterConfiguration overriddenClusterConfiguration = (ClusterConfiguration)this.getRegistry().get("_muleClusterConfiguration");
        if (overriddenClusterConfiguration != null) {
            this.clusterConfiguration = overriddenClusterConfiguration;
            this.clusterNodeIdPrefix = overriddenClusterConfiguration.getClusterNodeId() + "-";
        }
    }

    private void overridePollingController() {
        SchedulerController overriddenSchedulerController = (SchedulerController)this.getRegistry().get("_mulePollingController");
        if (overriddenSchedulerController != null) {
            this.schedulerController = overriddenSchedulerController;
        }
    }

    public void setMuleConfiguration(MuleConfiguration muleConfiguration) {
        this.config = muleConfiguration;
    }

    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        if (!(lifecycleManager instanceof MuleContextLifecycleManager)) {
            I18nMessage msg = I18nMessageFactory.createStaticMessage("lifecycle manager for MuleContext must be a MuleContextLifecycleManager");
            throw new MuleRuntimeException(msg);
        }
        this.lifecycleManager = (MuleContextLifecycleManager)lifecycleManager;
    }

    public void setRegistryBroker(RegistryBroker registryBroker) {
        this.registryBroker = registryBroker;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public void setMuleRegistry(MuleRegistry muleRegistry) {
        this.muleRegistryHelper = muleRegistry;
    }

    @Override
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    @Override
    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactType artifactType) {
        this.artifactType = artifactType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowTraceManager getFlowTraceManager() {
        if (this.flowTraceManager == null) {
            Object object = this.flowTraceManagerLock;
            synchronized (object) {
                if (this.flowTraceManager == null) {
                    try {
                        this.flowTraceManager = this.getRegistry().lookupObject(FlowTraceManager.class);
                    }
                    catch (RegistrationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        return this.flowTraceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventContextService getEventContextService() {
        if (this.eventContextService == null) {
            Object object = this.eventContextServiceLock;
            synchronized (object) {
                if (this.eventContextService == null) {
                    try {
                        this.eventContextService = this.getRegistry().lookupObject(EventContextService.class);
                    }
                    catch (RegistrationException e) {
                        throw new IllegalStateException("Could not get 'EventContextService' instance from registry.", e);
                    }
                }
            }
        }
        return this.eventContextService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ExceptionContextProvider> getExceptionContextProviders() {
        if (this.exceptionContextProviders == null) {
            Object object = this.exceptionContextProvidersLock;
            synchronized (object) {
                if (this.exceptionContextProviders == null) {
                    this.exceptionContextProviders = this.muleRegistryHelper.lookupByType(ExceptionContextProvider.class).values();
                }
            }
        }
        return this.exceptionContextProviders;
    }

    @Override
    public TransformationService getTransformationService() {
        if (this.transformationService == null) {
            this.transformationService = (TransformationService)this.getRegistry().get("_muleTransformationService");
        }
        return this.transformationService;
    }

    @Override
    public void setTransformationService(TransformationService transformationService) {
        this.transformationService = transformationService;
    }

    @Override
    public BootstrapServiceDiscoverer getRegistryBootstrapServiceDiscoverer() {
        return this.bootstrapServiceDiscoverer;
    }

    @Override
    public CustomizationService getCustomizationService() {
        return this.customizationService;
    }

    @Override
    public void setBootstrapServiceDiscoverer(BootstrapServiceDiscoverer bootstrapServiceDiscoverer) {
        this.bootstrapServiceDiscoverer = bootstrapServiceDiscoverer;
    }

    @Override
    public ConfigurationComponentLocator getConfigurationComponentLocator() {
        if (this.componentLocator == null) {
            this.componentLocator = (ConfigurationComponentLocator)this.getRegistry().lookupObject("_muleConfigurationComponentLocator");
        }
        return this.componentLocator;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setErrorTypeLocator(ErrorTypeLocator errorTypeLocator) {
        this.errorTypeLocator = errorTypeLocator;
    }

    @Override
    public ErrorTypeLocator getErrorTypeLocator() {
        return this.errorTypeLocator;
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        return this.errorTypeRepository;
    }

    public void setErrorTypeRepository(ErrorTypeRepository errorTypeRepository) {
        this.errorTypeRepository = errorTypeRepository;
    }

    @Override
    public Properties getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public void setDeploymentProperties(Properties deploymentProperties) {
        this.deploymentProperties = deploymentProperties;
    }

    public void setListeners(List<MuleContextListener> listeners) {
        this.listeners = listeners;
    }

    private org.mule.runtime.api.artifact.Registry getApiRegistry() {
        return (org.mule.runtime.api.artifact.Registry)this.getRegistry().lookupObject("_muleRegistry");
    }

    static {
        Hooks.onErrorDropped(error -> logger.debug("ERROR DROPPED " + error));
        Hooks.onNextDropped(event -> logger.debug("EVENT DROPPED " + event));
    }
}

