/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ApplicationClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<ApplicationClassLoaderBuilder> {
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private Domain domain;

    public ApplicationClassLoaderBuilder(DeployableArtifactClassLoaderFactory<ApplicationDescriptor> artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public MuleDeployableArtifactClassLoader build() throws IOException {
        Preconditions.checkState(this.domain != null, "Domain cannot be null");
        return (MuleDeployableArtifactClassLoader)super.build();
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return ApplicationClassLoaderBuilder.getApplicationId(this.domain.getArtifactId(), artifactDescriptor.getName());
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.domain.getArtifactClassLoader();
    }

    public ApplicationClassLoaderBuilder setDomain(Domain domain) {
        this.domain = domain;
        return this;
    }

    public static String getApplicationId(String domainId, String applicationId) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)domainId), "domainId cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)applicationId), "applicationName cannot be empty");
        return domainId + "/app/" + applicationId;
    }

    @Override
    protected ClassLoaderLookupPolicy getParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        HashMap<String, LookupStrategy> lookupStrategies = new HashMap<String, LookupStrategy>();
        DomainDescriptor descriptor = (DomainDescriptor)parentClassLoader.getArtifactDescriptor();
        descriptor.getClassLoaderModel().getExportedPackages().forEach(p -> lookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getPlugins()) {
            artifactPluginDescriptor.getClassLoaderModel().getExportedPackages().forEach(p -> lookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        }
        return parentClassLoader.getClassLoaderLookupPolicy().extend(lookupStrategies);
    }
}

