/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.CaseInsensitiveMapWrapper;

public class OptimizedCaseInsensitiveMapWrapper<T>
extends CaseInsensitiveMapWrapper<T> {
    public OptimizedCaseInsensitiveMapWrapper(Map map) {
        super(map);
    }

    public OptimizedCaseInsensitiveMapWrapper() {
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.baseMap.keySet());
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return new EntrySet(this.baseMap.entrySet());
    }

    @Override
    public Map<String, T> asCaseSensitiveMap() {
        return this.baseMap.entrySet().stream().collect(Collectors.toMap(entry -> ((CaseInsensitiveMapWrapper.CaseInsensitiveMapKey)entry.getKey()).getKey(), entry -> entry.getValue()));
    }

    private static abstract class AbstractConverterIterator<A, B>
    implements Iterator<B> {
        private final Iterator<A> aIterator;

        public AbstractConverterIterator(Set<A> set) {
            this.aIterator = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.aIterator.hasNext();
        }

        @Override
        public final void remove() {
            this.aIterator.remove();
        }

        @Override
        public final B next() {
            return this.convert(this.aIterator.next());
        }

        protected abstract B convert(A var1);
    }

    private static class EntryIterator<T>
    extends AbstractConverterIterator<Map.Entry<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, T>, Map.Entry<String, T>> {
        public EntryIterator(Set<Map.Entry<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, T>> entries) {
            super(entries);
        }

        @Override
        protected Map.Entry<String, T> convert(Map.Entry<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, T> next) {
            return new AbstractMap.SimpleEntry<String, T>(next.getKey().getKeyLowerCase(), next.getValue());
        }
    }

    private static class KeyIterator
    extends AbstractConverterIterator<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, String> {
        public KeyIterator(Set<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey> keys) {
            super(keys);
        }

        @Override
        protected String convert(CaseInsensitiveMapWrapper.CaseInsensitiveMapKey next) {
            return next.getKeyLowerCase();
        }
    }

    private static class EntrySet<T>
    extends CaseInsensitiveMapWrapper.AbstractConverterSet<Map.Entry<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, T>, Map.Entry<String, T>> {
        public EntrySet(Set<Map.Entry<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, T>> entries) {
            super(entries);
        }

        @Override
        protected Iterator<Map.Entry<String, T>> createIterator(Set<Map.Entry<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, T>> entries) {
            return new EntryIterator<T>(entries);
        }

        @Override
        protected Map.Entry<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, T> keyFor(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry o2 = (Map.Entry)o;
                return new AbstractMap.SimpleImmutableEntry(CaseInsensitiveMapWrapper.CaseInsensitiveMapKey.keyFor(o2.getKey()), o2.getValue());
            }
            return null;
        }
    }

    private static class KeySet
    extends CaseInsensitiveMapWrapper.AbstractConverterSet<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey, String> {
        public KeySet(Set<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey> keys) {
            super(keys);
        }

        @Override
        protected Iterator<String> createIterator(Set<CaseInsensitiveMapWrapper.CaseInsensitiveMapKey> keys) {
            return new KeyIterator(keys);
        }

        @Override
        protected CaseInsensitiveMapWrapper.CaseInsensitiveMapKey keyFor(Object o) {
            return CaseInsensitiveMapWrapper.CaseInsensitiveMapKey.keyFor(o);
        }
    }
}

