/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.domain.message;

import java.util.Collection;
import org.mule.api.annotation.Experimental;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.message.MessageWithHeaders;

@Experimental
public abstract class BaseMessageWithHeaders
implements MessageWithHeaders {
    protected MultiMap<String, String> headers;

    public BaseMessageWithHeaders(MultiMap<String, String> headers) {
        this.headers = headers != null ? headers.toImmutableMultiMap() : null;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public String getHeaderValue(String headerName) {
        return this.headers.get(headerName);
    }

    @Override
    public Collection<String> getHeaderValues(String headerName) {
        return this.headers.getAll(headerName);
    }

    @Override
    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeaderValueIgnoreCase(String headerName) {
        String lowerCaseValue = this.getHeaderValue(headerName.toLowerCase());
        return lowerCaseValue != null ? lowerCaseValue : this.getHeaderValue(headerName);
    }

    @Override
    public Collection<String> getHeaderValuesIgnoreCase(String headerName) {
        Collection<String> lowerCaseValue = this.getHeaderValues(headerName.toLowerCase());
        return lowerCaseValue != null ? lowerCaseValue : this.getHeaderValues(headerName);
    }
}

