/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.serializer.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.internal.serialization.AbstractSerializationProtocol;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.serializer.ArtifactClassLoaderObjectInputStream;
import org.mule.runtime.module.artifact.api.serializer.ArtifactClassLoaderObjectOutputStream;

@NoInstantiate
public class CustomJavaSerializationProtocol
extends AbstractSerializationProtocol {
    private final ClassLoaderRepository classLoaderRepository;

    public CustomJavaSerializationProtocol(ClassLoaderRepository classLoaderRepository) {
        Preconditions.checkArgument(classLoaderRepository != null, "artifactClassLoaderRepository cannot be null");
        this.classLoaderRepository = classLoaderRepository;
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        if (object instanceof CursorStreamProvider) {
            try (CursorStream cursor = (CursorStream)((CursorStreamProvider)object).openCursor();){
                object = IOUtils.toByteArray(cursor);
            }
        }
        this.validateForSerialization(object);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(512);
        try (ArtifactClassLoaderObjectOutputStream out = new ArtifactClassLoaderObjectOutputStream(this.classLoaderRepository, outputStream);){
            out.writeObject(object);
        }
        catch (IOException ex) {
            throw new SerializationException("Cannot serialize object", (Throwable)ex);
        }
        return outputStream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> T doDeserialize(InputStream inputStream, ClassLoader classLoader) throws Exception {
        Preconditions.checkArgument(inputStream != null, "Cannot deserialize a null stream");
        Preconditions.checkArgument(classLoader != null, "Cannot deserialize with a null classloader");
        try (ArtifactClassLoaderObjectInputStream in = new ArtifactClassLoaderObjectInputStream(this.classLoaderRepository, inputStream);){
            Object obj;
            Object object = obj = in.readObject();
            return (T)object;
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize object", (Throwable)ex);
        }
    }

    private void validateForSerialization(Object object) {
        if (object != null && !(object instanceof Serializable)) {
            throw new SerializationException(String.format("Was expecting a Serializable type. %s was found instead", object.getClass().getName()));
        }
    }
}

