/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.validation.ModelValidationUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConnectionProviderModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, ProblemsReporter problemsReporter) {
        HashSet<ConnectionProviderModel> globalConnectionProviders = new HashSet<ConnectionProviderModel>();
        HashMultimap configLevelConnectionProviders = HashMultimap.create();
        new ExtensionWalker((Multimap)configLevelConnectionProviders, globalConnectionProviders, problemsReporter){
            final /* synthetic */ Multimap val$configLevelConnectionProviders;
            final /* synthetic */ Set val$globalConnectionProviders;
            final /* synthetic */ ProblemsReporter val$problemsReporter;
            {
                this.val$configLevelConnectionProviders = multimap;
                this.val$globalConnectionProviders = set;
                this.val$problemsReporter = problemsReporter;
            }

            @Override
            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                if (owner instanceof ConfigurationModel) {
                    this.val$configLevelConnectionProviders.put((Object)((ConfigurationModel)owner), (Object)model);
                } else {
                    this.val$globalConnectionProviders.add(model);
                }
                ModelValidationUtils.validateConfigOverrideParametersNotAllowed(model, this.val$problemsReporter, "Connection");
            }
        }.walk(extensionModel);
        this.validateGlobalConnectionTypes(extensionModel, globalConnectionProviders, problemsReporter);
        this.validateConfigLevelConnectionTypes((Multimap<ConfigurationModel, ConnectionProviderModel>)configLevelConnectionProviders, problemsReporter);
    }

    private void validateGlobalConnectionTypes(ExtensionModel extensionModel, Set<ConnectionProviderModel> globalConnectionProviders, final ProblemsReporter problemsReporter) {
        if (globalConnectionProviders.isEmpty()) {
            return;
        }
        for (final ConnectionProviderModel connectionProviderModel : globalConnectionProviders) {
            final Type connectionType = MuleExtensionUtils.getConnectionType(connectionProviderModel);
            new IdempotentExtensionWalker(){

                @Override
                protected void onOperation(OperationModel operationModel) {
                    ConnectionProviderModelValidator.this.validateConnectionTypes(connectionProviderModel, operationModel, connectionType, problemsReporter);
                }

                @Override
                protected void onSource(SourceModel sourceModel) {
                    ConnectionProviderModelValidator.this.validateConnectionTypes(connectionProviderModel, sourceModel, connectionType, problemsReporter);
                }
            }.walk(extensionModel);
        }
    }

    private void validateConfigLevelConnectionTypes(Multimap<ConfigurationModel, ConnectionProviderModel> configLevelConnectionProviders, ProblemsReporter problemsReporter) {
        configLevelConnectionProviders.asMap().forEach((configModel, providerModels) -> {
            for (ConnectionProviderModel providerModel : providerModels) {
                Type connectionType = MuleExtensionUtils.getConnectionType(providerModel);
                configModel.getOperationModels().forEach(operationModel -> this.validateConnectionTypes(providerModel, (ComponentModel)operationModel, connectionType, problemsReporter));
            }
        });
    }

    private <T> Optional<Type> getConnectionType(EnrichableModel model) {
        Optional<ConnectivityModelProperty> connectivityProperty = model.getModelProperty(ConnectivityModelProperty.class);
        if (!connectivityProperty.isPresent() && model instanceof ParameterizedModel) {
            connectivityProperty = ((ParameterizedModel)((Object)model)).getAllParameterModels().stream().map(p -> p.getModelProperty(ConnectivityModelProperty.class).orElse(null)).filter(Objects::nonNull).findFirst();
        }
        return connectivityProperty.map(ConnectivityModelProperty::getConnectionType);
    }

    private void validateConnectionTypes(ConnectionProviderModel providerModel, ComponentModel componentModel, Type providerConnectionType, ProblemsReporter problemsReporter) {
        this.getConnectionType(componentModel).ifPresent(connectionType -> {
            if (!connectionType.isAssignableFrom(providerConnectionType)) {
                problemsReporter.addError(new Problem(providerModel, String.format("Component '%s' requires a connection of type '%s'. However, it also defines connection provider '%s' which yields connections of incompatible type '%s'", componentModel.getName(), connectionType.getName(), providerModel.getName(), providerConnectionType.getName())));
            }
        });
    }
}

