/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class RegistryLookupValueResolver<T>
implements ValueResolver<T> {
    private final String key;
    private final Once.RunOnce keyValidator;
    private Registry registry;

    public RegistryLookupValueResolver(String key) {
        this.key = key;
        this.keyValidator = Once.of(() -> Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)key), "A null or empty key was provided. Registry lookup cannot be performed with a blank key"));
    }

    @Override
    public T resolve(ValueResolvingContext context) throws MuleException {
        this.keyValidator.runOnce();
        return this.registry.lookupByName(this.key).orElseThrow(() -> new ConfigurationException(I18nMessageFactory.createStaticMessage(String.format("Element '%s' is not defined in the Mule Registry", this.key))));
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Inject
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

