/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.domain.entity.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.impl.service.server.grizzly.HttpParser;

public class StreamedMultipartHttpEntity
implements HttpEntity {
    private InputStream content;
    private String contentType;
    private Long contentLength;

    public StreamedMultipartHttpEntity(InputStream content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    public StreamedMultipartHttpEntity(InputStream content, String contentType, Long contentLength) {
        this(content, contentType);
        this.contentLength = contentLength;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public boolean isComposed() {
        return true;
    }

    @Override
    public InputStream getContent() throws UnsupportedOperationException {
        return this.content;
    }

    @Override
    public byte[] getBytes() throws UnsupportedOperationException {
        return IOUtils.toByteArray(this.content);
    }

    @Override
    public Collection<HttpPart> getParts() throws IOException, UnsupportedOperationException {
        return HttpParser.parseMultipartContent(this.content, this.contentType);
    }

    @Override
    public Optional<Long> getLength() {
        return Optional.ofNullable(this.contentLength);
    }
}

