/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.retry.policy.NoRetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.retry.policy.SimpleRetryPolicyTemplate;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class UntilSuccessful
extends AbstractMuleObjectOwner
implements Scope {
    private static final String UNTIL_SUCCESSFUL_MSG_PREFIX = "'until-successful' retries exhausted. Last exception message was: %s";
    private static final long DEFAULT_MILLIS_BETWEEN_RETRIES = 60000L;
    private static final int DEFAULT_RETRIES = 5;
    @Inject
    private SchedulerService schedulerService;
    private int maxRetries = 5;
    private Long millisBetweenRetries = 60000L;
    private MessageProcessorChain nestedChain;
    private Predicate<CoreEvent> shouldRetry;
    private RetryPolicyTemplate policyTemplate;
    private Scheduler timer;
    private List<Processor> processors;

    @Override
    public void initialise() throws InitialisationException {
        if (this.processors == null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("One message processor must be configured within 'until-successful'."), (Initialisable)this);
        }
        this.nestedChain = MessageProcessors.newChain(MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation()), this.processors);
        super.initialise();
        this.timer = this.schedulerService.cpuLightScheduler();
        this.policyTemplate = this.maxRetries != 0 ? new SimpleRetryPolicyTemplate(this.millisBetweenRetries, this.maxRetries) : new NoRetryPolicyTemplate();
        this.shouldRetry = event -> event.getError().isPresent();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.timer.stop();
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).flatMap(event -> Mono.from(MessageProcessors.processWithChildContext(event, (ReactiveProcessor)this.nestedChain, Optional.ofNullable(this.getLocation()))).transform(p -> this.policyTemplate.applyPolicy(p, this.getRetryPredicate(), e -> {}, this.getThrowableFunction((CoreEvent)event), this.timer)));
    }

    private Predicate<Throwable> getRetryPredicate() {
        return e -> e instanceof MessagingException && this.shouldRetry.test(((MessagingException)e).getEvent());
    }

    private Function<Throwable, Throwable> getThrowableFunction(CoreEvent event) {
        return throwable -> {
            Throwable cause = ExceptionUtils.getMessagingExceptionCause(throwable);
            CoreEvent exceptionEvent = event;
            if (throwable instanceof MessagingException) {
                exceptionEvent = ((MessagingException)throwable).getEvent();
            }
            return new MessagingException(exceptionEvent, new RetryPolicyExhaustedException(I18nMessageFactory.createStaticMessage(UNTIL_SUCCESSFUL_MSG_PREFIX, cause.getMessage()), cause, this), (Component)this);
        };
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public void setMillisBetweenRetries(long millisBetweenRetries) {
        this.millisBetweenRetries = millisBetweenRetries;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    protected List<Object> getOwnedObjects() {
        return Collections.singletonList(this.nestedChain);
    }
}

