/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.bytes.factory;

import java.io.InputStream;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;

@NoExtend
public abstract class AbstractCursorStreamProviderFactory
extends AbstractComponent
implements CursorStreamProviderFactory {
    private final ByteBufferManager bufferManager;
    protected final StreamingManager streamingManager;

    protected AbstractCursorStreamProviderFactory(ByteBufferManager bufferManager, StreamingManager streamingManager) {
        this.bufferManager = bufferManager;
        this.streamingManager = streamingManager;
    }

    @Override
    public final Object of(EventContext eventContext, InputStream inputStream) {
        if (inputStream instanceof CursorStream) {
            return this.streamingManager.manage(((CursorStream)inputStream).getProvider(), eventContext);
        }
        Object value = this.resolve(inputStream, eventContext);
        if (value instanceof CursorStreamProvider) {
            value = this.streamingManager.manage((CursorProvider)((CursorStreamProvider)value), eventContext);
        }
        return value;
    }

    @Override
    public final Object of(CoreEvent event, InputStream inputStream) {
        return this.of((EventContext)((BaseEventContext)event.getContext()).getRootContext(), inputStream);
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected abstract Object resolve(InputStream var1, EventContext var2);

    @Deprecated
    protected abstract Object resolve(InputStream var1, CoreEvent var2);
}

