/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;

public class ExpressionLanguageAdaptorHandler
implements ExtendedExpressionLanguageAdaptor {
    private static final String EXPR_PREFIX_LANGS_TOKEN = "LANGS";
    private static final String EXPR_PREFIX_PATTERN_TEMPLATE = "^\\s*(?:(?:#\\[)?\\s*(LANGS):|\\%(LANGS) \\d).*";
    static final String MVEL_NOT_INSTALLED_ERROR = "MVEL expression language configured as default but not installed";
    private final Pattern exprPrefixPattern;
    private Map<String, ExtendedExpressionLanguageAdaptor> expressionLanguages;
    private LoadingCache<String, ExtendedExpressionLanguageAdaptor> expressionLanguagesByExpressionCache = Caffeine.newBuilder().build(expression -> {
        String languagePrefix = this.getLanguagePrefix((String)expression);
        if (StringUtils.isEmpty((CharSequence)languagePrefix)) {
            if (this.isMelDefault()) {
                return this.expressionLanguages.get("mel");
            }
            return this.expressionLanguages.get("dw");
        }
        if (this.expressionLanguages.size() == 1) {
            return this.expressionLanguages.values().iterator().next();
        }
        ExtendedExpressionLanguageAdaptor extendedExpressionLanguageAdaptor = this.expressionLanguages.get(languagePrefix);
        if (extendedExpressionLanguageAdaptor == null) {
            throw new IllegalStateException(String.format("There is no expression language registered for '%s'", languagePrefix));
        }
        return extendedExpressionLanguageAdaptor;
    });
    private boolean melDefault = false;

    public ExpressionLanguageAdaptorHandler(ExtendedExpressionLanguageAdaptor defaultExtendedExpressionLanguage, ExtendedExpressionLanguageAdaptor mvelExpressionLanguage) {
        this.expressionLanguages = new HashMap<String, ExtendedExpressionLanguageAdaptor>();
        this.expressionLanguages.put("dw", defaultExtendedExpressionLanguage);
        if (mvelExpressionLanguage != null) {
            this.expressionLanguages.put("mel", mvelExpressionLanguage);
        }
        this.exprPrefixPattern = Pattern.compile(EXPR_PREFIX_PATTERN_TEMPLATE.replaceAll(EXPR_PREFIX_LANGS_TOKEN, StringUtils.join(this.expressionLanguages.keySet(), (char)'|')));
        this.melDefault = Boolean.valueOf(System.getProperty("mule.test.mel.default", "false"));
        if (this.isMelDefault() && mvelExpressionLanguage == null) {
            throw new IllegalStateException(MVEL_NOT_INSTALLED_ERROR);
        }
    }

    boolean isMelDefault() {
        return this.melDefault;
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionLanguages.get("dw").addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, BindingContext context) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, BindingContext context) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, expectedOutputType, event, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, ComponentLocation componentLocation, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, expectedOutputType, event, componentLocation, context, failOnNull);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, componentLocation, bindingContext);
    }

    @Override
    public TypedValue<?> evaluateLogExpression(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluateLogExpression(expression, event, componentLocation, bindingContext);
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.selectExpressionLanguage(expression).validate(expression);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, eventBuilder, componentLocation, bindingContext);
    }

    @Override
    public void enrich(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, Object object) {
        this.selectExpressionLanguage(expression).enrich(expression, event, eventBuilder, componentLocation, object);
    }

    @Override
    public void enrich(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, TypedValue value) {
        this.selectExpressionLanguage(expression).enrich(expression, event, eventBuilder, componentLocation, value);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).split(expression, event, componentLocation, bindingContext);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).split(expression, event, bindingContext);
    }

    private ExtendedExpressionLanguageAdaptor selectExpressionLanguage(String expression) {
        return (ExtendedExpressionLanguageAdaptor)this.expressionLanguagesByExpressionCache.get((Object)expression);
    }

    public String getLanguagePrefix(String expression) {
        Matcher matcher = this.exprPrefixPattern.matcher(expression);
        if (matcher.find()) {
            int i = 1;
            String currentGroup = null;
            while (currentGroup == null) {
                currentGroup = matcher.group(i++);
            }
            return currentGroup;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.expressionLanguages.toString() + "]";
    }
}

