/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.outbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.routing.MessageSequence;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurer;
import org.mule.runtime.core.internal.routing.outbound.PartitionedMessageSequence;
import org.mule.runtime.core.privileged.event.Acceptor;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.routing.DefaultRouterResultsHandler;
import org.mule.runtime.core.privileged.routing.RouterResultsHandler;

public abstract class AbstractMessageSequenceSplitter
extends AbstractInterceptingMessageProcessor
implements MuleContextAware {
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    protected int batchSize;
    protected String counterVariableName;
    protected Acceptor filterOnErrorTypeAcceptor = new Acceptor(){

        @Override
        public boolean acceptsAll() {
            return false;
        }

        @Override
        public boolean accept(CoreEvent event) {
            return false;
        }
    };

    @Override
    public final CoreEvent process(CoreEvent event) throws MuleException {
        if (this.isSplitRequired(event)) {
            MessageSequence<?> seq = this.splitMessageIntoSequence(event);
            if (!seq.isEmpty()) {
                return this.resultsHandler.aggregateResults(this.processParts(seq, event), event);
            }
            this.logger.warn("Splitter returned no results. If this is not expected, please check your split expression");
            return event;
        }
        return this.processNext(event);
    }

    protected boolean isSplitRequired(CoreEvent event) {
        return true;
    }

    protected abstract MessageSequence<?> splitMessageIntoSequence(CoreEvent var1) throws MuleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CoreEvent> processParts(MessageSequence<?> seq, CoreEvent originalEvent) throws MuleException {
        ArrayList<CoreEvent> resultEvents = new ArrayList<CoreEvent>();
        int correlationSequence = 0;
        MessageSequence<?> messageSequence = seq;
        if (this.batchSize > 1) {
            messageSequence = new PartitionedMessageSequence(seq, this.batchSize);
        }
        Integer count = messageSequence.size();
        CoreEvent lastResult = null;
        while (messageSequence.hasNext()) {
            ++correlationSequence;
            CoreEvent.Builder builder = CoreEvent.builder(originalEvent);
            if (this.counterVariableName != null) {
                builder.addVariable(this.counterVariableName, correlationSequence);
            }
            builder.groupCorrelation(Optional.of(count != null ? GroupCorrelation.of(correlationSequence, count) : GroupCorrelation.of(correlationSequence)));
            Object nextValue = messageSequence.next();
            this.initEventBuilder(nextValue, originalEvent, builder, this.resolvePropagatedFlowVars(lastResult));
            try {
                CoreEvent resultEvent = MessageProcessors.processToApplyWithChildContext(builder.build(), this.applyNext());
                if (resultEvent == null) continue;
                resultEvents.add(PrivilegedEvent.builder(originalEvent.getContext(), resultEvent).session(((PrivilegedEvent)originalEvent).getSession()).build());
                lastResult = resultEvent;
            }
            catch (MessagingException e) {
                if (this.filterOnErrorTypeAcceptor.accept(e.getEvent())) continue;
                throw e;
            }
            finally {
                if (!(nextValue instanceof EventBuilderConfigurer)) continue;
                ((EventBuilderConfigurer)nextValue).eventCompleted();
            }
        }
        if (correlationSequence == 1) {
            this.logger.debug("Splitter only returned a single result. If this is not expected, please check your split expression");
        }
        return resultEvents;
    }

    protected Map<String, ?> resolvePropagatedFlowVars(CoreEvent lastResult) {
        return Collections.emptyMap();
    }

    private void initEventBuilder(Object sequenceValue, CoreEvent originalEvent, CoreEvent.Builder builder, Map<String, ?> flowVarsFromLastResult) {
        if (sequenceValue instanceof EventBuilderConfigurer) {
            ((EventBuilderConfigurer)sequenceValue).configure(builder);
        } else if (sequenceValue instanceof CoreEvent) {
            CoreEvent payloadAsEvent = (CoreEvent)sequenceValue;
            builder.message(payloadAsEvent.getMessage());
            for (String flowVarName : payloadAsEvent.getVariables().keySet()) {
                if (flowVarsFromLastResult.containsKey(flowVarName)) continue;
                builder.addVariable(flowVarName, payloadAsEvent.getVariables().get(flowVarName).getValue(), payloadAsEvent.getVariables().get(flowVarName).getDataType());
            }
        } else if (sequenceValue instanceof Message) {
            Message message = (Message)sequenceValue;
            builder.message(message);
        } else if (sequenceValue instanceof TypedValue) {
            builder.message(Message.builder().payload((TypedValue)sequenceValue).build());
        } else if (sequenceValue instanceof Collection) {
            builder.message(Message.builder(originalEvent.getMessage()).value(((Collection)sequenceValue).stream().map(v -> v instanceof TypedValue ? ((TypedValue)v).getValue() : v).collect(Collectors.toList())).build());
        } else {
            builder.message(Message.builder(originalEvent.getMessage()).value(sequenceValue).build());
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }
}

