/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.type.annotation.DslBaseType;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.SubstitutionGroup;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypedValueTypeAnnotation;

public final class ExtensionMetadataTypeUtils {
    private static final List<MetadataFormat> KNOWN_METADATA_FORMATS = Arrays.asList(MetadataFormat.JAVA, MetadataFormat.XML, MetadataFormat.JSON, MetadataFormat.CSV);

    private ExtensionMetadataTypeUtils() {
    }

    public static Optional<String> getId(MetadataType metadataType) {
        return JavaTypeUtils.getId(metadataType);
    }

    public static <T> Optional<Class<T>> getType(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getType(metadataType, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Optional<Class<T>> getType(MetadataType metadataType, ClassLoader classloader) {
        try {
            return Optional.of(JavaTypeUtils.getType(metadataType, classloader));
        }
        catch (Throwable e) {
            return Optional.empty();
        }
    }

    public static String getAlias(ObjectFieldType fieldType) {
        return fieldType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElseGet(() -> MetadataTypeUtils.getLocalPart(fieldType));
    }

    public static String getAlias(MetadataType metadataType) {
        return ExtensionMetadataTypeUtils.getAlias(metadataType, "");
    }

    public static String getAlias(MetadataType metadataType, String defaultName) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(defaultName);
    }

    public static boolean isFinal(MetadataType metadataType) {
        return metadataType.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isFinal).orElse(false);
    }

    public static boolean isMap(MetadataType metadataType) {
        return metadataType.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isMap).orElseGet(() -> metadataType.getAnnotation(TypeIdAnnotation.class).map(TypeIdAnnotation::getValue).map(id -> id.equals(Map.class.getName())).orElse(false));
    }

    public static boolean isFlattenedParameterGroup(MetadataType type) {
        return type.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }

    public static boolean allowsInlineDefinition(MetadataType type) {
        final Reference<Boolean> supported = new Reference<Boolean>(true);
        type.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                metadataType.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsInlineDefinition).ifPresent(supported::set);
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitObject(ObjectType objectType) {
                Optional<ParameterDslAnnotation> paramDsl = objectType.getAnnotation(ParameterDslAnnotation.class);
                Optional<TypeDslAnnotation> typeDsl = objectType.getAnnotation(TypeDslAnnotation.class);
                if (typeDsl.isPresent() && paramDsl.isPresent()) {
                    supported.set(typeDsl.get().allowsInlineDefinition() && paramDsl.get().allowsInlineDefinition());
                } else if (typeDsl.isPresent()) {
                    supported.set(typeDsl.get().allowsInlineDefinition());
                } else {
                    paramDsl.map(ParameterDslAnnotation::allowsInlineDefinition).ifPresent(supported::set);
                }
            }
        });
        return supported.get();
    }

    public static boolean allowsTopLevelDefinition(MetadataType type) {
        return type.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
    }

    public static boolean allowsReferences(MetadataType type) {
        return type.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsReferences).orElse(true);
    }

    public static ExpressionSupport getExpressionSupport(MetadataType metadataType) {
        return metadataType.getAnnotation(ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).orElse(ExpressionSupport.SUPPORTED);
    }

    public static Optional<LayoutModel> getLayoutModel(MetadataType metadataType) {
        if (metadataType.getAnnotation(LayoutTypeAnnotation.class).isPresent()) {
            LayoutTypeAnnotation layoutTypeAnnotation = metadataType.getAnnotation(LayoutTypeAnnotation.class).get();
            return Optional.of(layoutTypeAnnotation.getLayoutModel());
        }
        return Optional.empty();
    }

    public static boolean isInfrastructure(MetadataType type) {
        return type.getAnnotation(InfrastructureTypeAnnotation.class).isPresent();
    }

    public static boolean acceptsReferences(MetadataType metadataType) {
        return metadataType.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsReferences).orElse(true);
    }

    public static boolean isBasic(MetadataType metadataType) {
        final Reference<Boolean> basic = new Reference<Boolean>(false);
        metadataType.accept(new BasicTypeMetadataVisitor(){

            @Override
            protected void visitBasicType(MetadataType metadataType) {
                basic.set(true);
            }
        });
        return basic.get();
    }

    public static Optional<SubstitutionGroup> getSubstitutionGroup(MetadataType metadataType) {
        return metadataType.getAnnotation(TypeDslAnnotation.class).flatMap(TypeDslAnnotation::getSubstitutionGroup);
    }

    public static Optional<DslBaseType> getBaseType(MetadataType metadataType) {
        return metadataType.getAnnotation(TypeDslAnnotation.class).flatMap(TypeDslAnnotation::getDslBaseType);
    }

    public static MetadataFormat toMetadataFormat(MediaType mediaType) {
        String rfc = mediaType.toRfcString();
        return KNOWN_METADATA_FORMATS.stream().filter(f -> f.getValidMimeTypes().stream().anyMatch(rfc::matches)).findFirst().orElseGet(() -> new MetadataFormat(rfc, rfc, rfc));
    }

    public static boolean isJavaCollection(MetadataType metadataType) {
        Optional type;
        if (MetadataTypeUtils.isCollection(metadataType) && (type = ExtensionMetadataTypeUtils.getType(metadataType)).isPresent()) {
            return Collection.class.isAssignableFrom(type.get());
        }
        return false;
    }

    public static boolean isTypedValue(MetadataType metadataType) {
        return metadataType.getAnnotation(TypedValueTypeAnnotation.class).isPresent();
    }
}

