/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.google.common.io.Files;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactConstants;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleScope;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.maven.ArtifactClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.HeavyweightClassLoaderModelBuilder;
import org.mule.runtime.module.deployment.impl.internal.maven.LightweightClassLoaderModelBuilder;
import org.mule.tools.api.classloader.ClassLoaderModelJsonSerializer;
import org.mule.tools.api.classloader.model.Artifact;
import org.mule.tools.api.classloader.model.ClassLoaderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenClassLoaderModelLoader
implements ClassLoaderModelLoader {
    public static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR = "classloader-model.json";
    public static final String CLASSLOADER_MODEL_JSON_PATCH_DESCRIPTOR = "classloader-model-patch.json";
    public static final String CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION = Paths.get("META-INF", "mule-artifact", "classloader-model.json").toString();
    public static final String CLASSLOADER_MODEL_JSON_PATCH_DESCRIPTOR_LOCATION = Paths.get("META-INF", "mule-artifact", "classloader-model-patch.json").toString();
    public static final String CLASSLOADER_MODEL_MAVEN_REACTOR_RESOLVER = "_classLoaderModelMavenReactorResolver";
    private static final String POM_LOCATION_FORMAT = "%s/%s-%s.pom";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final File temporaryFolder;
    private MavenClient mavenClient;

    public AbstractMavenClassLoaderModelLoader(MavenClient mavenClient, File temporaryFolder) {
        this.mavenClient = mavenClient;
        this.temporaryFolder = temporaryFolder;
    }

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    public final org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        return this.createClassLoaderModel(artifactFile, attributes, artifactType);
    }

    private org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel createClassLoaderModel(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        if (this.isHeavyPackage(artifactFile)) {
            return this.createHeavyPackageClassLoaderModel(artifactFile, attributes);
        }
        return this.createLightPackageClassLoaderModel(artifactFile, attributes, artifactType);
    }

    private org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel createHeavyPackageClassLoaderModel(File artifactFile, Map<String, Object> attributes) {
        File classLoaderModelDescriptor = this.getClassLoaderModelDescriptor(artifactFile);
        ClassLoaderModel packagerClassLoaderModel = this.getPackagerClassLoaderModel(classLoaderModelDescriptor);
        File deployableArtifactRepositoryFolder = this.getDeployableArtifactRepositoryFolder(artifactFile);
        HeavyweightClassLoaderModelBuilder classLoaderModelBuilder = this.newHeavyWeightClassLoaderModelBuilder(artifactFile, packagerClassLoaderModel, attributes);
        classLoaderModelBuilder.exportingPackages(new HashSet<String>(this.getAttribute(attributes, "exportedPackages"))).exportingPrivilegedPackages(new HashSet<String>(this.getAttribute(attributes, "privilegedExportedPackages")), new HashSet<String>(this.getAttribute(attributes, "privilegedArtifactIds"))).exportingResources(new HashSet<String>(this.getAttribute(attributes, "exportedResources")));
        Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> patchBundleDependencies = this.getPatchedBundledDependencies(artifactFile, deployableArtifactRepositoryFolder);
        Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> bundleDependencies = packagerClassLoaderModel.getDependencies().stream().map(artifact -> {
            Optional<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> patchedBundledDependency = patchBundleDependencies.stream().filter(bundleDependency -> bundleDependency.getDescriptor().getGroupId().equals(artifact.getArtifactCoordinates().getGroupId()) && bundleDependency.getDescriptor().getArtifactId().equals(artifact.getArtifactCoordinates().getArtifactId())).findAny();
            return patchedBundledDependency.orElse(this.createBundleDependencyFromPackagerDependency(deployableArtifactRepositoryFolder).apply((Artifact)artifact));
        }).collect(Collectors.toSet());
        this.loadUrls(artifactFile, classLoaderModelBuilder, bundleDependencies);
        classLoaderModelBuilder.dependingOn(bundleDependencies);
        return classLoaderModelBuilder.build();
    }

    protected abstract ClassLoaderModel getPackagerClassLoaderModel(File var1);

    private Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> getPatchedBundledDependencies(File artifactFile, File deployableArtifactRepositoryFolder) {
        HashSet<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> patchBundleDependencies = new HashSet<org.mule.runtime.module.artifact.api.descriptor.BundleDependency>();
        File classLoaderModelPatchDescriptor = this.getClassLoaderModelPatchDescriptor(artifactFile);
        if (classLoaderModelPatchDescriptor.exists()) {
            ClassLoaderModel packagerClassLoaderModelPatch = ClassLoaderModelJsonSerializer.deserialize(classLoaderModelPatchDescriptor);
            patchBundleDependencies.addAll(packagerClassLoaderModelPatch.getDependencies().stream().map(artifact -> this.createBundleDependencyFromPackagerDependency(deployableArtifactRepositoryFolder).apply((Artifact)artifact)).collect(Collectors.toSet()));
        }
        return patchBundleDependencies;
    }

    private File getDeployableArtifactRepositoryFolder(File artifactFile) {
        if (artifactFile.isDirectory()) {
            return artifactFile;
        }
        return this.findRepositoryFolder(artifactFile).getParentFile();
    }

    private File findRepositoryFolder(File artifactFile) {
        while (!MuleFoldersUtil.getMuleHomeFolder().equals(artifactFile) && !"repository".equals(artifactFile.getName())) {
            artifactFile = artifactFile.getParentFile();
        }
        if (!"repository".equals(artifactFile.getName()) || !artifactFile.isDirectory()) {
            throw new IllegalStateException("Unable to find repository folder for artifact " + artifactFile.getAbsolutePath());
        }
        return artifactFile;
    }

    private Function<Artifact, org.mule.runtime.module.artifact.api.descriptor.BundleDependency> createBundleDependencyFromPackagerDependency(File artifactFile) {
        return d -> {
            File bundle = new File(artifactFile, d.getUri().toString());
            return new BundleDependency.Builder().setDescriptor(new BundleDescriptor.Builder().setArtifactId(d.getArtifactCoordinates().getArtifactId()).setGroupId(d.getArtifactCoordinates().getGroupId()).setClassifier(d.getArtifactCoordinates().getClassifier()).setType(d.getArtifactCoordinates().getType()).setVersion(d.getArtifactCoordinates().getVersion()).build()).setBundleUri(bundle.toURI()).build();
        };
    }

    private boolean isHeavyPackage(File artifactFile) {
        return this.getClassLoaderModelDescriptor(artifactFile).exists();
    }

    protected File getClassLoaderModelDescriptor(File artifactFile) {
        return new File(artifactFile, CLASSLOADER_MODEL_JSON_DESCRIPTOR_LOCATION);
    }

    protected File getClassLoaderModelPatchDescriptor(File artifactFile) {
        return new File(artifactFile, CLASSLOADER_MODEL_JSON_PATCH_DESCRIPTOR_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel createLightPackageClassLoaderModel(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) {
        Optional<File> mavenRepository = Optional.ofNullable(this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation());
        if (!mavenRepository.isPresent()) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Missing Maven local repository configuration while trying to resolve class loader model for lightweight artifact: %s", artifactFile.getName())));
        }
        boolean includeProvidedDependencies = this.includeProvidedDependencies(artifactType);
        Optional<MavenReactorResolver> mavenReactorResolver = Optional.ofNullable((MavenReactorResolver)attributes.get(CLASSLOADER_MODEL_MAVEN_REACTOR_RESOLVER));
        Optional<File> temporaryDirectory = Optional.of(Files.createTempDir());
        try {
            List<BundleDependency> dependencies = this.mavenClient.resolveArtifactDependencies(artifactFile, this.includeTestDependencies(attributes), includeProvidedDependencies, mavenRepository, mavenReactorResolver, temporaryDirectory);
            Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> nonProvidedDependencies = dependencies.stream().filter(mavenClientDependency -> !mavenClientDependency.getScope().equals((Object)org.mule.maven.client.api.model.BundleScope.PROVIDED)).map(this::convertBundleDependency).collect(Collectors.toSet());
            LightweightClassLoaderModelBuilder classLoaderModelBuilder = this.newLightweightClassLoaderModelBuilder(artifactFile, this.mavenClient, attributes, nonProvidedDependencies, this.temporaryFolder);
            classLoaderModelBuilder.exportingPackages(new HashSet<String>(this.getAttribute(attributes, "exportedPackages"))).exportingPrivilegedPackages(new HashSet<String>(this.getAttribute(attributes, "privilegedExportedPackages")), new HashSet<String>(this.getAttribute(attributes, "privilegedArtifactIds"))).exportingResources(new HashSet<String>(this.getAttribute(attributes, "exportedResources"))).includeTestDependencies(Boolean.valueOf(this.getSimpleAttribute(attributes, "includeTestDependencies", "false")));
            Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> missingApiDependencyBundles = this.findMissingApiDependencies(dependencies, attributes, includeProvidedDependencies, mavenRepository, mavenReactorResolver, temporaryDirectory);
            this.loadUrls(artifactFile, classLoaderModelBuilder, Stream.concat(nonProvidedDependencies.stream(), missingApiDependencyBundles.stream()).collect(Collectors.toSet()));
            Stream<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> allBundleDependencies = dependencies.stream().map(this::convertBundleDependency);
            classLoaderModelBuilder.dependingOn(Stream.concat(allBundleDependencies, missingApiDependencyBundles.stream()).collect(Collectors.toSet()));
            org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel classLoaderModel = classLoaderModelBuilder.build();
            return classLoaderModel;
        }
        finally {
            FileUtils.deleteQuietly((File)temporaryDirectory.get());
        }
    }

    protected abstract LightweightClassLoaderModelBuilder newLightweightClassLoaderModelBuilder(File var1, MavenClient var2, Map<String, Object> var3, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> var4, File var5);

    protected abstract HeavyweightClassLoaderModelBuilder newHeavyWeightClassLoaderModelBuilder(File var1, ClassLoaderModel var2, Map<String, Object> var3);

    private Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> findMissingApiDependencies(List<BundleDependency> dependencies, Map<String, Object> attributes, boolean includeProvidedDependencies, Optional<File> mavenRepository, Optional<MavenReactorResolver> mavenReactorResolver, Optional<File> temporaryDirectory) {
        Set<BundleDependency> apiDependencies = dependencies.stream().filter(dependency -> {
            Optional<String> classifier = dependency.getDescriptor().getClassifier();
            return classifier.isPresent() && ArtifactConstants.API_CLASSIFIERS.contains(classifier.get());
        }).collect(Collectors.toSet());
        ArrayDeque dependenciesToCheck = new ArrayDeque(apiDependencies);
        HashSet<BundleDependency> missingApiDependencies = new HashSet<BundleDependency>();
        while (!dependenciesToCheck.isEmpty()) {
            File pom = this.getPom((BundleDependency)dependenciesToCheck.pop());
            for (BundleDependency apiDependency : this.mavenClient.resolveArtifactDependencies(pom, this.includeTestDependencies(attributes), includeProvidedDependencies, mavenRepository, mavenReactorResolver, temporaryDirectory)) {
                if (!this.noEquivalentPresent(apiDependencies, apiDependency) || !this.noEquivalentPresent(missingApiDependencies, apiDependency)) continue;
                missingApiDependencies.add(apiDependency);
                dependenciesToCheck.add(apiDependency);
            }
        }
        return missingApiDependencies.stream().map(this::convertBundleDependency).collect(Collectors.toSet());
    }

    private File getPom(BundleDependency dependency) {
        String zipPath = dependency.getBundleUri().getPath();
        String dependencyPath = zipPath.substring(0, zipPath.lastIndexOf("/"));
        BundleDescriptor descriptor = dependency.getDescriptor();
        return new File(String.format(POM_LOCATION_FORMAT, dependencyPath, descriptor.getArtifactId(), descriptor.getVersion()));
    }

    private boolean noEquivalentPresent(Set<BundleDependency> dependencies, BundleDependency dependency) {
        return dependencies.stream().noneMatch(currentApiArtifact -> currentApiArtifact.getDescriptor().equals(dependency.getDescriptor()));
    }

    protected abstract boolean includeProvidedDependencies(ArtifactType var1);

    protected org.mule.runtime.module.artifact.api.descriptor.BundleDependency convertBundleDependency(BundleDependency mavenClientDependency) {
        BundleDependency.Builder builder = new BundleDependency.Builder().setScope(BundleScope.valueOf(mavenClientDependency.getScope().name())).setBundleUri(mavenClientDependency.getBundleUri()).setDescriptor(this.convertBundleDescriptor(mavenClientDependency.getDescriptor()));
        return builder.build();
    }

    private org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor convertBundleDescriptor(BundleDescriptor descriptor) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder().setGroupId(descriptor.getGroupId()).setArtifactId(descriptor.getArtifactId()).setVersion(descriptor.getBaseVersion()).setType(descriptor.getType());
        descriptor.getClassifier().ifPresent(builder::setClassifier);
        return builder.build();
    }

    private void loadUrls(File artifactFile, ArtifactClassLoaderModelBuilder classLoaderModelBuilder, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> dependencies) {
        classLoaderModelBuilder.containing(this.getUrl(artifactFile, artifactFile));
        this.addArtifactSpecificClassloaderConfiguration(classLoaderModelBuilder);
        this.addDependenciesToClasspathUrls(classLoaderModelBuilder, dependencies);
    }

    private URL getUrl(File artifactFile, File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ArtifactDescriptorCreateException(String.format("There was an exception obtaining the URL for the artifact [%s], file [%s]", artifactFile.getAbsolutePath(), file.getAbsolutePath()), e);
        }
    }

    private void addDependenciesToClasspathUrls(ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, Set<org.mule.runtime.module.artifact.api.descriptor.BundleDependency> dependencies) {
        dependencies.stream().filter(dependency -> !"mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null))).filter(dependency -> dependency.getBundleUri() != null).forEach(dependency -> {
            try {
                classLoaderModelBuilder.containing(dependency.getBundleUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(e);
            }
        });
    }

    private List<String> getAttribute(Map<String, Object> attributes, String attribute) {
        ArrayList attributeObject = attributes.getOrDefault(attribute, new ArrayList());
        Preconditions.checkArgument(attributeObject instanceof List, String.format("The '%s' attribute must be of '%s', found '%s'", attribute, List.class.getName(), attributeObject.getClass().getName()));
        return attributeObject;
    }

    private <T> T getSimpleAttribute(Map<String, Object> attributes, String attribute, T defaultValue) {
        return (T)attributes.getOrDefault(attribute, defaultValue);
    }

    protected boolean includeTestDependencies(Map<String, Object> attributes) {
        return false;
    }

    protected void addArtifactSpecificClassloaderConfiguration(ArtifactClassLoaderModelBuilder classLoaderModelBuilder) {
    }
}

